"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSearchSourceMock = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getSearchSourceMock = esSearchResponse => jest.fn().mockImplementation(() => ({
  setParent: jest.fn(),
  setField: jest.fn(),
  fetch: jest.fn().mockResolvedValue(esSearchResponse ? esSearchResponse : {
    aggregations: {
      termsAgg: {
        buckets: [{
          key: 'Zurich Airport',
          doc_count: 691
        }, {
          key: 'Xi an Xianyang International Airport',
          doc_count: 526
        }]
      }
    }
  })
}));
exports.getSearchSourceMock = getSearchSourceMock;