"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineNotFoundFlyout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
var _navigation = require("../../services/navigation");
var _utils = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineNotFoundFlyout = ({
  onClose,
  pipelineName,
  error
}) => {
  const {
    history
  } = (0, _shared_imports.useKibana)().services;
  const renderErrorCallOut = () => {
    if (error.statusCode === 404 && (0, _utils.isIntegrationsPipeline)(pipelineName)) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.ingestPipelines.list.missingCustomPipeline.title",
          defaultMessage: "Custom pipeline does not exist"
        }),
        color: "warning",
        iconType: "warning",
        "data-test-subj": "missingCustomPipeline"
      }, /*#__PURE__*/_react.default.createElement("p", {
        "data-test-subj": "cause"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.missingCustomPipeline.text",
        defaultMessage: "The pipeline {pipelineName} does not exist.",
        values: {
          pipelineName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, pipelineName)
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
        color: "warning"
      }, (0, _public.reactRouterNavigate)(history, (0, _navigation.getCreatePath)({
        pipelineName
      })), {
        "data-test-subj": "createCustomPipeline"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.missingCustomPipeline.button",
        defaultMessage: "Create pipeline"
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.list.loadingError",
        defaultMessage: "Error loading pipeline"
      }),
      color: "danger",
      iconType: "warning",
      "data-test-subj": "pipelineError"
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "cause"
    }, (0, _utils.getErrorText)(error)));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    size: "m",
    maxWidth: 550,
    "data-test-subj": "pipelineErrorFlyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, pipelineName && /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: "notFoundFlyoutTitle",
    "data-test-subj": "title"
  }, /*#__PURE__*/_react.default.createElement("h2", null, pipelineName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, renderErrorCallOut(), " "));
};
exports.PipelineNotFoundFlyout = PipelineNotFoundFlyout;