"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SetProcessor = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../../../../shared_imports");
var _utils = require("../../../utils");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
var _field_components = require("../field_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Optional fields config
const fieldsConfig = {
  mediaType: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    defaultValue: 'application/json',
    serializer: _shared.from.undefinedIfValue('application/json'),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.mediaTypeFieldLabel', {
      defaultMessage: 'Media Type'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.mediaTypeHelpText",
      defaultMessage: "Media type for encoding value."
    })
  },
  override: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: true,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(true),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.overrideFieldLabel', {
      defaultMessage: 'Override'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.overrideFieldHelpText",
      defaultMessage: "If enabled, overwrite existing field values. If disabled, only update {nullValue} fields.",
      values: {
        nullValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'null')
      }
    })
  },
  ignore_empty_value: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.ignoreEmptyValueFieldLabel', {
      defaultMessage: 'Ignore empty value'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.ignoreEmptyValueFieldHelpText",
      defaultMessage: "If {valueField} is {nullValue} or an empty string, do not update the field.",
      values: {
        valueField: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'value'),
        nullValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'null')
      }
    })
  },
  value: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    defaultValue: value => {
      return (0, _shared.isXJsonValue)(value) ? '{}' : '';
    },
    deserializer: value => {
      return (0, _shared.isXJsonValue)(value) ? _shared.to.xJsonString(value) : value;
    },
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.valueFieldLabel', {
      defaultMessage: 'Value'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.valueFieldHelpText",
      defaultMessage: "Value for the field."
    }),
    validations: [{
      validator: ({
        value,
        path,
        formData
      }) => {
        // Only require a value if it's undefined and copy_from is also not defined.
        // Empty strings, 0, and false are valid values.
        if ((0, _lodash.isUndefined)(value) && (0, _lodash.isUndefined)(formData['fields.copy_from'])) {
          return {
            path,
            message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.requiredValue', {
              defaultMessage: 'A value is required.'
            })
          };
        }
      }
    }, {
      validator: args => {
        const {
          customData: {
            value: isJson
          }
        } = args;
        if (isJson) {
          return (0, _shared.isXJsonField)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.valueInvalidJsonError', {
            defaultMessage: 'Invalid JSON'
          }), {
            allowEmptyString: true
          })({
            ...args
          });
        }
      }
    }]
  },
  copy_from: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    fieldsToValidateOnChange: ['fields.value', 'fields.copy_from'],
    validations: [{
      validator: ({
        value,
        path
      }) => {
        if ((0, _lodash.isEmpty)(value)) {
          return {
            path,
            message: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.requiredCopyFrom', {
              defaultMessage: 'A copy from value is required.'
            })
          };
        }
      }
    }],
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.copyFromFieldLabel', {
      defaultMessage: 'Copy from'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.copyFromFieldHelpText",
      defaultMessage: "Field to copy into {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'Field')
      }
    })
  },
  toggle_custom_field: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.enablingCopyFieldLabel', {
      defaultMessage: 'Use Copy instead of Value'
    }),
    fieldsToValidateOnChange: ['fields.value', 'fields.copy_from'],
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.setForm.enablingCopydHelpText",
      defaultMessage: "Specify fields to copy into {field} instead of setting a {value}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'Field'),
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'Value')
      }
    })
  }
};

/**
 * Disambiguate name from the Set data structure
 */
const SetProcessor = () => {
  const {
    getFieldDefaultValue,
    setFieldValue
  } = (0, _shared_imports.useFormContext)();
  const [{
    fields
  }] = (0, _shared_imports.useFormData)({
    watch: ['fields.value', 'fields.copy_from']
  });
  const isCopyFromDefined = getFieldDefaultValue('fields.copy_from') !== undefined;
  const [isCopyFromEnabled, setIsCopyFrom] = (0, _react.useState)(isCopyFromDefined);
  const [isDefineAsJson, setIsDefineAsJson] = (0, _react.useState)(undefined);
  const getIsJsonValue = isJson => {
    setIsDefineAsJson(isJson);
  };
  const toggleCustom = (0, _react.useCallback)(() => {
    const newIsCopyFrom = !isCopyFromEnabled;
    setIsCopyFrom(prev => !prev);
    setFieldValue('fields.value', !newIsCopyFrom && isDefineAsJson ? '{}' : '');
    setFieldValue('fields.copy_from', '');
  }, [isCopyFromEnabled, isDefineAsJson, setFieldValue]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.setForm.fieldNameField', {
      defaultMessage: 'Field to insert or update.'
    })
  }), !isCopyFromEnabled && /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.value,
    component: _field_components.XJsonToggle,
    path: "fields.value",
    componentProps: {
      handleIsJson: getIsJsonValue,
      fieldType: 'text'
    },
    validationData: isDefineAsJson
  }), !isCopyFromEnabled && (0, _utils.hasTemplateSnippet)(fields === null || fields === void 0 ? void 0 : fields.value) && /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'mediaTypeSelectorField',
        options: [{
          value: 'application/json',
          text: 'application/json'
        }, {
          value: 'text/plain',
          text: 'text/plain'
        }, {
          value: 'application/x-www-form-urlencoded',
          text: 'application/x-www-form-urlencoded'
        }]
      }
    },
    config: fieldsConfig.mediaType,
    component: _shared_imports.SelectField,
    path: "fields.media_type"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.toggle_custom_field,
    component: _shared_imports.ToggleField,
    "data-test-subj": "toggleCustomField",
    onChange: toggleCustom,
    defaultValue: isCopyFromEnabled,
    path: ""
  }), isCopyFromEnabled && /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "copyFromInput",
    config: fieldsConfig.copy_from,
    component: _shared_imports.Field,
    path: "fields.copy_from"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.override,
    component: _shared_imports.ToggleField,
    path: "fields.override",
    "data-test-subj": "overrideField"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.ignore_empty_value,
    component: _shared_imports.ToggleField,
    path: "fields.ignore_empty_value",
    "data-test-subj": "ignoreEmptyField"
  }));
};
exports.SetProcessor = SetProcessor;