"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Append = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _utils = require("../../../utils");
var _shared_imports = require("../../../../../../shared_imports");
var _shared = require("./shared");
var _field_name_field = require("./common_fields/field_name_field");
var _field_components = require("../field_components");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  value: {
    defaultValue: value => {
      return (0, _shared.isXJsonValue)(value) ? '{}' : [];
    },
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: value => {
      return (0, _shared.isXJsonValue)(value) ? _shared.to.xJsonString(value) : _shared.to.arrayOfStrings(value);
    },
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.valueFieldLabel', {
      defaultMessage: 'Value'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.valueFieldHelpText', {
      defaultMessage: 'Values to append.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.valueRequiredError', {
        defaultMessage: 'A value is required.'
      }))
    }, {
      validator: args => {
        const {
          customData: {
            value: isJson
          }
        } = args;
        if (isJson) {
          return (0, _shared.isXJsonField)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.valueInvalidJsonError', {
            defaultMessage: 'Invalid JSON'
          }), {
            allowEmptyString: true
          })({
            ...args
          });
        }
      }
    }]
  },
  allow_duplicates: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: true,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(true),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.allowDuplicatesFieldLabel', {
      defaultMessage: 'Allow duplicates'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.allowDuplicatesFieldHelpText', {
      defaultMessage: 'Allow appending values already present in the field.'
    })
  },
  media_type: {
    type: _shared_imports.FIELD_TYPES.SELECT,
    defaultValue: 'application/json',
    serializer: _shared.from.undefinedIfValue('application/json'),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.mediaTypeFieldLabel', {
      defaultMessage: 'Media type'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.appendForm.mediaTypeFieldHelpText",
      defaultMessage: "Media type for encoding value."
    })
  }
};
const Append = () => {
  const [{
    fields
  }] = (0, _shared_imports.useFormData)({
    watch: ['fields.value']
  });
  const [isDefineAsJson, setIsDefineAsJson] = (0, _react.useState)(undefined);
  const getIsJsonValue = isJson => {
    setIsDefineAsJson(isJson);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.appendForm.fieldHelpText', {
      defaultMessage: 'Field to append values to.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "allowDuplicatesSwitch",
    config: fieldsConfig.allow_duplicates,
    component: _shared_imports.ToggleField,
    path: "fields.allow_duplicates"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.value,
    component: _field_components.XJsonToggle,
    path: "fields.value",
    componentProps: {
      handleIsJson: getIsJsonValue,
      fieldType: 'combox'
    },
    validationData: isDefineAsJson
  }), (0, _utils.hasTemplateSnippet)(fields === null || fields === void 0 ? void 0 : fields.value) && /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'mediaTypeSelectorField',
        options: [{
          value: 'application/json',
          text: 'application/json'
        }, {
          value: 'text/plain',
          text: 'text/plain'
        }, {
          value: 'application/x-www-form-urlencoded',
          text: 'application/x-www-form-urlencoded'
        }]
      }
    },
    config: fieldsConfig.media_type,
    component: _shared_imports.SelectField,
    path: "fields.media_type"
  }));
};
exports.Append = Append;