"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.assertQueryStructure = void 0;
var _boom = _interopRequireDefault(require("@hapi/boom"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidFilter = query => {
  const boolClause = query.bool;
  if (!boolClause || Object.keys(boolClause).length === 0) {
    return false;
  }
  return [boolClause.filter, boolClause.must, boolClause.must_not, boolClause.should].filter(Boolean).every(clause => Array.isArray(clause) || clause === undefined);
};
const assertQueryStructure = query => {
  if (!!query && !isValidFilter(query)) {
    throw _boom.default.badRequest('Invalid query');
  }
};
exports.assertQueryStructure = assertQueryStructure;