"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getApmHostNames = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getApmHostNames = async ({
  apmDataAccessServices,
  apmDocumentSources,
  from: start,
  to: end,
  query,
  limit
}) => {
  return apmDataAccessServices.getHostNames({
    documentSources: apmDocumentSources,
    query,
    start,
    end,
    size: limit
  });
};
exports.getApmHostNames = getApmHostNames;