"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolvePersistedDataView = exports.resolveDataView = exports.resolveAdHocDataView = void 0;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const resolveDataView = async ({
  dataViewId,
  dataViewsService
}) => {
  try {
    return await resolvePersistedDataView({
      dataViewsService,
      dataViewId
    });
  } catch {
    return resolveAdHocDataView({
      dataViewsService,
      dataViewId,
      attributes: {
        timeFieldName: _constants.TIMESTAMP_FIELD
      }
    });
  }
};
exports.resolveDataView = resolveDataView;
const resolvePersistedDataView = async ({
  dataViewsService,
  dataViewId
}) => {
  var _dataView$timeFieldNa, _dataView$fields;
  const dataView = await dataViewsService.get(dataViewId, false);
  return {
    indices: dataView.getIndexPattern(),
    timeFieldName: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : _constants.TIMESTAMP_FIELD,
    fields: (_dataView$fields = dataView.fields) !== null && _dataView$fields !== void 0 ? _dataView$fields : [],
    dataViewReference: dataView
  };
};
exports.resolvePersistedDataView = resolvePersistedDataView;
const resolveAdHocDataView = async ({
  dataViewsService,
  dataViewId,
  attributes
}) => {
  const {
    name,
    timeFieldName
  } = attributes;
  const dataViewReference = await dataViewsService.create({
    id: dataViewId,
    name,
    title: dataViewId,
    timeFieldName
  }, false, false);
  return {
    indices: dataViewId,
    timeFieldName,
    fields: dataViewReference.fields,
    dataViewReference
  };
};
exports.resolveAdHocDataView = resolveAdHocDataView;