"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Legend = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _types = require("../../../../../common/inventory/types");
var _gradient_legend = require("./gradient_legend");
var _steps_legend = require("./steps_legend");
var _stepped_gradient_legend = require("./stepped_gradient_legend");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Legend = ({
  legend,
  bounds,
  formatter
}) => {
  return /*#__PURE__*/_react.default.createElement(LegendContainer, null, _types.GradientLegendRT.is(legend) && /*#__PURE__*/_react.default.createElement(_gradient_legend.GradientLegend, {
    formatter: formatter,
    legend: legend,
    bounds: bounds
  }), _types.StepLegendRT.is(legend) && /*#__PURE__*/_react.default.createElement(_steps_legend.StepLegend, {
    formatter: formatter,
    legend: legend
  }), _types.SteppedGradientLegendRT.is(legend) && /*#__PURE__*/_react.default.createElement(_stepped_gradient_legend.SteppedGradientLegend, {
    formatter: formatter,
    bounds: bounds,
    legend: legend
  }));
};
exports.Legend = Legend;
const LegendContainer = _common.euiStyled.div`
  margin: 0 10px;
  display: flex;
`;