"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLogColumnButtonAndPopover = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _uuid = require("uuid");
var _common = require("@kbn/kibana-react-plugin/common");
var _use_visibility_state = require("../../../hooks/use_visibility_state");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddLogColumnButtonAndPopover = ({
  addLogColumn,
  availableFields,
  isDisabled
}) => {
  const {
    isVisible: isOpen,
    show: openPopover,
    hide: closePopover
  } = (0, _use_visibility_state.useVisibilityState)(false);
  const availableColumnOptions = (0, _react.useMemo)(() => [{
    optionProps: {
      append: /*#__PURE__*/_react.default.createElement(SystemColumnBadge, null),
      'data-test-subj': 'addTimestampLogColumn',
      // this key works around EuiSelectable using a lowercased label as
      // key, which leads to conflicts with field names
      key: 'timestamp',
      label: 'Timestamp'
    },
    columnConfiguration: {
      timestampColumn: {
        id: (0, _uuid.v4)()
      }
    }
  }, {
    optionProps: {
      'data-test-subj': 'addMessageLogColumn',
      append: /*#__PURE__*/_react.default.createElement(SystemColumnBadge, null),
      // this key works around EuiSelectable using a lowercased label as
      // key, which leads to conflicts with field names
      key: 'message',
      label: 'Message'
    },
    columnConfiguration: {
      messageColumn: {
        id: (0, _uuid.v4)()
      }
    }
  }, ...availableFields.map(field => ({
    optionProps: {
      'data-test-subj': `addFieldLogColumn addFieldLogColumn:${field}`,
      // this key works around EuiSelectable using a lowercased label as
      // key, which leads to conflicts with fields that only differ in the
      // case (e.g. the metricbeat mongodb module)
      key: `field-${field}`,
      label: field
    },
    columnConfiguration: {
      fieldColumn: {
        id: (0, _uuid.v4)(),
        field
      }
    }
  }))], [availableFields]);
  const availableOptions = (0, _react.useMemo)(() => availableColumnOptions.map(availableColumnOption => availableColumnOption.optionProps), [availableColumnOptions]);
  const handleColumnSelection = (0, _react.useCallback)(selectedOptions => {
    closePopover();
    const selectedOptionIndex = selectedOptions.findIndex(selectedOption => selectedOption.checked === 'on');
    const selectedOption = availableColumnOptions[selectedOptionIndex];
    addLogColumn(selectedOption.columnConfiguration);
  }, [addLogColumn, availableColumnOptions, closePopover]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "addLogColumnButton",
      isDisabled: isDisabled,
      iconType: "plusInCircle",
      onClick: openPopover
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.sourceConfiguration.addLogColumnButtonLabel",
      defaultMessage: "Add column"
    })),
    closePopover: closePopover,
    id: "addLogColumn",
    isOpen: isOpen,
    ownFocus: true,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    height: 600,
    listProps: selectableListProps,
    onChange: handleColumnSelection,
    options: availableOptions,
    searchable: true,
    searchProps: searchProps,
    singleSelection: true
  }, (list, search) => /*#__PURE__*/_react.default.createElement(SelectableContent, {
    "data-test-subj": "addLogColumnPopover"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, search), list)));
};
exports.AddLogColumnButtonAndPopover = AddLogColumnButtonAndPopover;
const searchProps = {
  'data-test-subj': 'fieldSearchInput'
};
const selectableListProps = {
  showIcons: false
};
const SystemColumnBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.infra.sourceConfiguration.systemColumnBadgeLabel",
  defaultMessage: "System"
}));
const SelectableContent = _common.euiStyled.div`
  width: 400px;
`;