"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogsAppRoutes = void 0;
var _translations = require("../../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogsAppRoutes = ({
  isLogsStreamEnabled
}) => {
  const routes = {
    logsAnomalies: {
      id: 'anomalies',
      title: _translations.logsAnomaliesTitle,
      path: '/anomalies'
    },
    logsCategories: {
      id: 'log-categories',
      title: _translations.logCategoriesTitle,
      path: '/log-categories'
    },
    settings: {
      id: 'settings',
      title: _translations.settingsTitle,
      path: '/settings'
    }
  };
  if (isLogsStreamEnabled) {
    routes.stream = {
      id: 'stream',
      title: _translations.streamTitle,
      path: '/stream'
    };
  }
  return routes;
};
exports.getLogsAppRoutes = getLogsAppRoutes;