"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PaginationControls = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const previousPageLabel = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTablePreviousPageLabel', {
  defaultMessage: 'Previous page'
});
const nextPageLabel = _i18n.i18n.translate('xpack.infra.logs.analysis.anomaliesTableNextPageLabel', {
  defaultMessage: 'Next page'
});
const PaginationControls = ({
  fetchPreviousPage,
  fetchNextPage,
  page,
  isLoading
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraPaginationControlsButton",
    iconType: "arrowLeft",
    isDisabled: !fetchPreviousPage || isLoading,
    onClick: fetchPreviousPage,
    "aria-label": previousPageLabel
  }), /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement("strong", null, page)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "infraPaginationControlsButton",
    iconType: "arrowRight",
    isDisabled: !fetchNextPage || isLoading,
    onClick: fetchNextPage,
    "aria-label": nextPageLabel
  }))));
};
exports.PaginationControls = PaginationControls;