"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogTextScaleControls = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var React = _interopRequireWildcard(require("react"));
var _log_text_scale = require("../../../common/log_text_scale");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class LogTextScaleControls extends React.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "setTextScale", textScale => {
      if ((0, _log_text_scale.isTextScale)(textScale)) {
        this.props.setTextScale(textScale);
      }
    });
  }
  render() {
    const {
      availableTextScales,
      textScale
    } = this.props;
    return /*#__PURE__*/React.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logs.customizeLogs.textSizeFormRowLabel",
        defaultMessage: "Text Size"
      })
    }, /*#__PURE__*/React.createElement(_eui.EuiRadioGroup, {
      "data-test-subj": "infraRadioGroup",
      options: availableTextScales.map(availableTextScale => ({
        id: availableTextScale.toString(),
        label: /*#__PURE__*/React.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.logs.customizeLogs.textSizeRadioGroup",
          defaultMessage: "{textScale, select, small {Small} medium {Medium} large {Large} other {{textScale}} }",
          values: {
            textScale: availableTextScale
          }
        })
      })),
      idSelected: textScale,
      onChange: this.setTextScale
    }));
  }
}
exports.LogTextScaleControls = LogTextScaleControls;