"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContainerMetrics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _docker_charts = require("../../../charts/docker_charts");
var _constants = require("../../../constants");
var _use_integration_check = require("../../../hooks/use_integration_check");
var _kubernetes_charts = require("../../../charts/kubernetes_charts");
var _use_tab_switcher = require("../../../hooks/use_tab_switcher");
var _types = require("../../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContainerMetrics = props => {
  const {
    showTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const isDockerContainer = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.docker
  });
  const isKubernetesContainer = (0, _use_integration_check.useIntegrationCheck)({
    dependsOn: _constants.INTEGRATIONS.kubernetesContainer
  });
  const onClick = metric => {
    showTab(_types.ContentTabIds.METRICS, {
      scrollTo: metric
    });
  };
  if (!isDockerContainer && !isKubernetesContainer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s"
  }, isDockerContainer && _constants.DOCKER_METRIC_TYPES.map(metric => /*#__PURE__*/_react.default.createElement(_docker_charts.DockerCharts, (0, _extends2.default)({
    key: metric
  }, props, {
    metric: metric,
    onShowAll: onClick
  }))), !isDockerContainer && isKubernetesContainer && _constants.KUBERNETES_METRIC_TYPES.map(metric => /*#__PURE__*/_react.default.createElement(_kubernetes_charts.KubernetesContainerCharts, (0, _extends2.default)({
    key: metric
  }, props, {
    metric: metric,
    onShowAll: onClick
  })))));
};
exports.ContainerMetrics = ContainerMetrics;