"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InfraMetricTypeRT = exports.InfraAssetMetricsRT = exports.InfraAssetMetricsItemRT = exports.InfraAssetMetadataTypeRT = exports.InfraAssetMetadataRT = exports.GetInfraMetricsResponsePayloadRT = exports.GetInfraMetricsRequestParamsRT = exports.GetInfraMetricsRequestBodyPayloadRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
var _asset_type = require("../shared/asset_type");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InfraMetricTypeRT = exports.InfraMetricTypeRT = rt.keyof({
  cpu: null,
  cpuV2: null,
  normalizedLoad1m: null,
  diskSpaceUsage: null,
  memory: null,
  memoryFree: null,
  rx: null,
  tx: null,
  rxV2: null,
  txV2: null
});
const InfraAssetMetadataTypeRT = exports.InfraAssetMetadataTypeRT = rt.keyof({
  'cloud.provider': null,
  'host.ip': null,
  'host.os.name': null
});
const InfraAssetMetricsRT = exports.InfraAssetMetricsRT = rt.type({
  name: InfraMetricTypeRT,
  value: rt.union([rt.number, rt.null])
});
const InfraAssetMetadataRT = exports.InfraAssetMetadataRT = rt.type({
  // keep the actual field name from the index mappings
  name: InfraAssetMetadataTypeRT,
  value: rt.union([rt.number, rt.string, rt.null])
});
const GetInfraMetricsRequestBodyPayloadRT = exports.GetInfraMetricsRequestBodyPayloadRT = rt.intersection([rt.partial({
  query: rt.UnknownRecord
}), rt.type({
  limit: rt.union([(0, _ioTsUtils.inRangeRt)(1, 500), (0, _ioTsUtils.createLiteralValueFromUndefinedRT)(500)]),
  metrics: rt.array(InfraMetricTypeRT),
  from: _ioTsUtils.isoToEpochRt,
  to: _ioTsUtils.isoToEpochRt
})]);
const GetInfraMetricsRequestParamsRT = exports.GetInfraMetricsRequestParamsRT = _asset_type.AssetTypeRT;
const InfraAssetMetricsItemRT = exports.InfraAssetMetricsItemRT = rt.intersection([rt.type({
  name: rt.string,
  metrics: rt.array(InfraAssetMetricsRT),
  metadata: rt.array(InfraAssetMetadataRT),
  hasSystemMetrics: rt.boolean
}), rt.partial({
  alertsCount: rt.number
})]);
const GetInfraMetricsResponsePayloadRT = exports.GetInfraMetricsResponsePayloadRT = rt.intersection([_asset_type.AssetTypeRT, rt.type({
  nodes: rt.array(InfraAssetMetricsItemRT)
})]);