"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMetricsViewInAppUrl = exports.getInventoryViewInAppUrl = exports.flatAlertRuleParams = exports.ALERT_RULE_PARAMETERS_NODE_TYPE = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _moment = _interopRequireDefault(require("moment"));
var _rison = require("@kbn/rison");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _lodash = require("lodash");
var _constants = require("../../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERT_RULE_PARAMTERS_INVENTORY_METRIC_ID = `${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.metric`;
const ALERT_RULE_PARAMETERS_NODE_TYPE = exports.ALERT_RULE_PARAMETERS_NODE_TYPE = `${_ruleDataUtils.ALERT_RULE_PARAMETERS}.nodeType`;
const CUSTOM_METRIC_TYPE = 'custom';
const flatAlertRuleParams = (params, pKey = '') => {
  return Object.entries(params).reduce((acc, [key, field]) => {
    const objectKey = pKey.length ? `${pKey}.${key}` : key;
    if (typeof field === 'object' && field != null) {
      if (Array.isArray(field) && field.length > 0) {
        return Object.assign(acc, flatAlertRuleParams(field[0], objectKey));
      } else {
        return Object.assign(acc, flatAlertRuleParams(field, objectKey));
      }
    }
    acc[objectKey] = Array.isArray(field) ? field : [field];
    return acc;
  }, {});
};
exports.flatAlertRuleParams = flatAlertRuleParams;
const getInventoryViewInAppUrl = ({
  fields,
  assetDetailsLocator,
  inventoryLocator
}) => {
  if (!assetDetailsLocator || !inventoryLocator) {
    throw new Error('Locators for Asset Details and Inventory are required');
  }

  /* Temporary Solution -> https://github.com/elastic/kibana/issues/137033
   * In the alert table from timelines plugin (old table), we are using an API who is flattening all the response
   * from elasticsearch to Record<string, string[]>, The new alert table API from TriggersActionUI is not doing that
   * anymore, it is trusting and returning the way it has been done from the field API from elasticsearch. I think
   * it is better to trust elasticsearch and the mapping of the doc. When o11y will only use the new alert table from
   * triggersActionUI then we will stop using this flattening way and we will update the code to work with fields API,
   * it will be less magic.
   */
  const inventoryFields = fields[_ruleDataUtils.ALERT_RULE_PARAMETERS] ? {
    ...fields,
    ...flatAlertRuleParams(fields[_ruleDataUtils.ALERT_RULE_PARAMETERS], _ruleDataUtils.ALERT_RULE_PARAMETERS)
  } : fields;
  const nodeType = (0, _lodash.castArray)(inventoryFields[ALERT_RULE_PARAMETERS_NODE_TYPE])[0];
  if (!nodeType) {
    return '';
  }
  const assetIdField = (0, _common.findInventoryModel)(nodeType).fields.id;
  const assetId = inventoryFields[assetIdField];
  const assetDetailsSupported = Object.values(_common2.SupportedAssetTypes).includes(nodeType);
  const criteriaMetric = inventoryFields[ALERT_RULE_PARAMTERS_INVENTORY_METRIC_ID][0];
  if (assetId && assetDetailsSupported) {
    return getLinkToAssetDetails({
      assetId,
      assetType: nodeType,
      timestamp: inventoryFields[_ruleDataUtils.TIMESTAMP],
      alertMetric: criteriaMetric,
      assetDetailsLocator
    });
  }
  const linkToParams = {
    nodeType,
    timestamp: Date.parse(inventoryFields[_ruleDataUtils.TIMESTAMP]),
    customMetric: '',
    metric: ''
  };

  // We always pick the first criteria metric for the URL

  if (criteriaMetric === CUSTOM_METRIC_TYPE) {
    const criteriaCustomMetricId = inventoryFields[`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.customMetric.id`][0];
    const criteriaCustomMetricAggregation = inventoryFields[`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.customMetric.aggregation`][0];
    const criteriaCustomMetricField = inventoryFields[`${_ruleDataUtils.ALERT_RULE_PARAMETERS}.criteria.customMetric.field`][0];
    const customMetric = (0, _rison.encode)({
      id: criteriaCustomMetricId,
      type: CUSTOM_METRIC_TYPE,
      field: criteriaCustomMetricField,
      aggregation: criteriaCustomMetricAggregation
    });
    linkToParams.customMetric = customMetric;
    linkToParams.metric = customMetric;
  } else {
    linkToParams.metric = (0, _rison.encode)({
      type: criteriaMetric
    });
  }
  return inventoryLocator.getRedirectUrl({
    ...linkToParams
  });
};
exports.getInventoryViewInAppUrl = getInventoryViewInAppUrl;
const getMetricsViewInAppUrl = ({
  fields,
  groupBy,
  assetDetailsLocator,
  metricsExplorerLocator
}) => {
  if (!assetDetailsLocator || !metricsExplorerLocator) {
    throw new Error('Locators for Asset Details and Metrics Explorer are required');
  }
  if (!groupBy) {
    return metricsExplorerLocator.getRedirectUrl({});
  }

  // creates an object of asset details supported assetType by their assetId field name
  const assetTypeByAssetId = Object.values(_common2.SupportedAssetTypes).reduce((acc, curr) => {
    acc[(0, _common.findInventoryModel)(curr).fields.id] = curr;
    return acc;
  }, {});

  // detemines if the groupBy has a field that the asset details supports
  const supportedAssetId = groupBy.find(field => !!assetTypeByAssetId[field]);
  // assigns a nodeType if the groupBy field is supported by asset details
  const supportedAssetType = supportedAssetId ? assetTypeByAssetId[supportedAssetId] : undefined;
  if (supportedAssetType) {
    const assetId = fields[(0, _common.findInventoryModel)(supportedAssetType).fields.id];

    // A supported asset type can still return no id. In such a case, we can't
    // generate a valid link, so we redirect to Metrics Explorer.
    if (!assetId) {
      return metricsExplorerLocator.getRedirectUrl({});
    }
    const timestamp = fields[_ruleDataUtils.TIMESTAMP];
    return getLinkToAssetDetails({
      assetId,
      assetType: supportedAssetType,
      timestamp,
      assetDetailsLocator
    });
  } else {
    return metricsExplorerLocator.getRedirectUrl({});
  }
};
exports.getMetricsViewInAppUrl = getMetricsViewInAppUrl;
function getLinkToAssetDetails({
  assetId,
  assetType,
  timestamp,
  alertMetric,
  assetDetailsLocator
}) {
  return assetDetailsLocator.getRedirectUrl({
    assetId,
    assetType,
    assetDetails: {
      dateRange: {
        from: timestamp,
        to: (0, _moment.default)(timestamp).add(_constants.fifteenMinutesInMilliseconds, 'ms').toISOString()
      },
      ...(alertMetric && alertMetric !== CUSTOM_METRIC_TYPE ? {
        alertMetric
      } : undefined)
    }
  });
}