"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unflattenAttributes = unflattenAttributes;
var _saferLodashSet = require("@kbn/safer-lodash-set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function unflattenAttributes(flat) {
  const result = {};
  for (const key in flat) {
    if (Object.hasOwn(flat, key)) {
      // split on dot; numeric segments cause array creation
      (0, _saferLodashSet.set)(result, key.split('.'), flat[key]);
    }
  }
  return result;
}