"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.naturalLanguageToEsql = naturalLanguageToEsql;
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _inferenceCommon = require("@kbn/inference-common");
var _doc_base = require("./doc_base");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const loadDocBase = (0, _lodash.once)(() => _doc_base.EsqlDocumentBase.load());
function naturalLanguageToEsql({
  client,
  connectorId,
  tools,
  toolChoice,
  logger,
  functionCalling,
  maxRetries,
  retryConfiguration,
  system,
  metadata,
  ...rest
}) {
  return (0, _rxjs.from)(loadDocBase()).pipe((0, _rxjs.switchMap)(docBase => {
    const systemMessage = docBase.getSystemMessage();
    const messages = 'input' in rest ? [{
      role: _inferenceCommon.MessageRole.User,
      content: rest.input
    }] : rest.messages;
    const askLlmToRespond = (0, _actions.generateEsqlTask)({
      connectorId,
      chatCompleteApi: client.chatComplete,
      messages,
      docBase,
      logger,
      systemMessage,
      functionCalling,
      maxRetries,
      retryConfiguration,
      metadata,
      toolOptions: {
        tools,
        toolChoice
      },
      system
    });
    return (0, _actions.requestDocumentation)({
      connectorId,
      functionCalling,
      maxRetries,
      retryConfiguration,
      outputApi: client.output,
      messages,
      system: systemMessage,
      metadata,
      toolOptions: {
        tools,
        toolChoice
      }
    }).pipe((0, _rxjs.switchMap)(documentationEvent => {
      var _documentationEvent$o, _documentationEvent$o2;
      return askLlmToRespond({
        documentationRequest: {
          commands: (_documentationEvent$o = documentationEvent.output) === null || _documentationEvent$o === void 0 ? void 0 : _documentationEvent$o.commands,
          functions: (_documentationEvent$o2 = documentationEvent.output) === null || _documentationEvent$o2 === void 0 ? void 0 : _documentationEvent$o2.functions
        }
      });
    }));
  }));
}