"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RegexWorkerService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _piscina = _interopRequireDefault(require("piscina"));
var _execute_regex_rule_task = require("./execute_regex_rule_task");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function runTaskSync(payload) {
  return (0, _execute_regex_rule_task.executeRegexRulesTask)(payload);
}
class RegexWorkerService {
  constructor(config, logger) {
    (0, _defineProperty2.default)(this, "enabled", void 0);
    (0, _defineProperty2.default)(this, "worker", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    this.logger = logger;
    this.config = config;
    this.enabled = config.enabled;
    if (this.enabled) {
      this.logger.debug(`Initializing regex worker pool (min=${this.config.minThreads} | max=${this.config.maxThreads} | idle=${this.config.idleTimeout.asMilliseconds()}ms)`);
      this.worker = new _piscina.default({
        filename: require.resolve('./regex_worker_wrapper.js'),
        minThreads: this.config.minThreads,
        maxThreads: this.config.maxThreads,
        idleTimeout: this.config.idleTimeout.asMilliseconds()
      });
    }
  }

  /**
   * Execute a task in a worker.  Falls back to synchronous execution when the
   * worker is disabled
   */
  async run(payload) {
    if (!this.enabled) {
      return runTaskSync(payload);
    }
    if (!this.worker) {
      throw new Error('Regex worker pool was not initialized');
    }
    const controller = new AbortController();
    const timer = setTimeout(() => controller.abort(), this.config.taskTimeout.asMilliseconds());
    try {
      return await this.worker.run(payload, {
        signal: controller.signal
      });
    } catch (err) {
      if ((err === null || err === void 0 ? void 0 : err.name) === 'AbortError') {
        if (this.worker.threads.length > 0) {
          // Attempt to terminate stuck threads
          await Promise.all(this.worker.threads.map(async thread => {
            try {
              await thread.terminate();
            } catch (e) {
              // Ignore termination errors
            }
          }));
        }
        throw new Error('Regex anonymization task timed out');
      }
      throw err;
    } finally {
      clearTimeout(timer);
    }
  }
  async stop() {
    var _this$worker;
    await ((_this$worker = this.worker) === null || _this$worker === void 0 ? void 0 : _this$worker.destroy());
  }
}
exports.RegexWorkerService = RegexWorkerService;