"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.anonymizeRecords = anonymizeRecords;
var _lodash = require("lodash");
var _execute_regex_rules = require("./execute_regex_rules");
var _execute_ner_rule = require("./execute_ner_rule");
var _resolve_overlaps_and_mask = require("./resolve_overlaps_and_mask");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function anonymizeRecords({
  input,
  anonymizationRules,
  regexWorker,
  esClient
}) {
  let state = {
    records: input.concat(),
    anonymizations: []
  };
  const [regexRules, nerRules] = (0, _lodash.partition)(anonymizationRules, rule => rule.type === 'RegExp');
  const detectedRegexEntities = await (0, _execute_regex_rules.executeRegexRules)({
    records: state.records,
    rules: regexRules,
    regexWorker
  });

  // Process detected regex matches to resolve overlaps and apply masks
  state = (0, _resolve_overlaps_and_mask.resolveOverlapsAndMask)({
    detectedMatches: detectedRegexEntities,
    state,
    rules: regexRules
  });
  if (!nerRules.length) {
    return state;
  }
  for (const nerRule of nerRules) {
    state = await (0, _execute_ner_rule.executeNerRule)({
      state,
      rule: nerRule,
      esClient
    });
  }
  return state;
}