"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.manuallyCountPromptTokens = exports.manuallyCountCompletionTokens = void 0;
var _gptTokenizer = require("gpt-tokenizer");
var _utils = require("../../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const manuallyCountPromptTokens = request => {
  var _request$tools;
  // per https://github.com/openai/openai-cookbook/blob/main/examples/How_to_count_tokens_with_tiktoken.ipynb
  const tokensFromMessages = (0, _gptTokenizer.encode)(request.messages.map(msg => `<|start|>${msg.role}\n${msg.content}\n${'name' in msg ? msg.name : 'function_call' in msg && msg.function_call ? msg.function_call.name + '\n' + msg.function_call.arguments : ''}<|end|>`).join('\n')).length;

  // this is an approximation. OpenAI cuts off a function schema
  // at a certain level of nesting, so their token count might
  // be lower than what we are calculating here.
  const tokensFromFunctions = request.tools ? (0, _gptTokenizer.encode)((_request$tools = request.tools) === null || _request$tools === void 0 ? void 0 : _request$tools.map(({
    function: fn
  }) => {
    return `${fn.name}:${fn.description}:${JSON.stringify(fn.parameters)}`;
  }).join('\n')).length : 0;
  return tokensFromMessages + tokensFromFunctions;
};
exports.manuallyCountPromptTokens = manuallyCountPromptTokens;
const manuallyCountCompletionTokens = chunks => {
  var _message$tool_calls;
  const message = (0, _utils.mergeChunks)(chunks);
  const tokenFromContent = (0, _gptTokenizer.encode)(message.content).length;
  const tokenFromToolCalls = (_message$tool_calls = message.tool_calls) !== null && _message$tool_calls !== void 0 && _message$tool_calls.length ? (0, _gptTokenizer.encode)(message.tool_calls.map(toolCall => {
    return JSON.stringify(toolCall);
  }).join('\n')).length : 0;
  return tokenFromContent + tokenFromToolCalls;
};
exports.manuallyCountCompletionTokens = manuallyCountCompletionTokens;