"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.correctCommonEsqlMistakes = void 0;
var _ast = require("./ast");
var _non_ast = require("./non_ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Correct some common ES|QL syntax and grammar mistakes that LLM can potentially do.
 *
 * Correcting the query is done in two steps:
 * 1. we try to correct the *syntax*, without AST (given it requires a valid syntax)
 * 2. we try to correct the *grammar*, using AST this time.
 */
const correctCommonEsqlMistakes = query => {
  const {
    output: outputWithoutAst,
    isCorrection: correctionWithoutAst
  } = (0, _non_ast.correctCommonEsqlMistakes)(query);
  const {
    output: corrected,
    corrections
  } = (0, _ast.correctQueryWithAst)(outputWithoutAst);
  return {
    input: query,
    output: corrected,
    isCorrection: correctionWithoutAst || corrections.length > 0
  };
};
exports.correctCommonEsqlMistakes = correctCommonEsqlMistakes;