"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtensionsService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ExtensionsService {
  constructor() {
    (0, _defineProperty2.default)(this, "_actions", []);
    (0, _defineProperty2.default)(this, "_banners", []);
    (0, _defineProperty2.default)(this, "_filters", []);
    (0, _defineProperty2.default)(this, "_badges", [{
      matchIndex: index => {
        return index.isFrozen;
      },
      label: _i18n.i18n.translate('xpack.idxMgmt.frozenBadgeLabel', {
        defaultMessage: 'Frozen'
      }),
      filterExpression: 'isFrozen:true',
      color: 'primary'
    }]);
    (0, _defineProperty2.default)(this, "_toggles", [{
      matchIndex: index => {
        return index.hidden;
      },
      label: _i18n.i18n.translate('xpack.idxMgmt.indexTable.hiddenIndicesSwitchLabel', {
        defaultMessage: 'Include hidden indices'
      }),
      name: 'includeHiddenIndices'
    }]);
    (0, _defineProperty2.default)(this, "_columns", []);
    (0, _defineProperty2.default)(this, "_emptyListContent", null);
    (0, _defineProperty2.default)(this, "_indexDetailsTabs", []);
    (0, _defineProperty2.default)(this, "_indexOverviewContent", null);
    (0, _defineProperty2.default)(this, "_indexMappingsContent", null);
    (0, _defineProperty2.default)(this, "_indexDetailsPageRoute", null);
    (0, _defineProperty2.default)(this, "service", void 0);
  }
  setup() {
    this.service = {
      addAction: this.addAction.bind(this),
      addBadge: this.addBadge.bind(this),
      addBanner: this.addBanner.bind(this),
      addFilter: this.addFilter.bind(this),
      addToggle: this.addToggle.bind(this),
      addColumn: this.addColumn.bind(this),
      setEmptyListContent: this.setEmptyListContent.bind(this),
      addIndexDetailsTab: this.addIndexDetailsTab.bind(this),
      setIndexOverviewContent: this.setIndexOverviewContent.bind(this),
      setIndexMappingsContent: this.setIndexMappingsContent.bind(this),
      setIndexDetailsPageRoute: this.setIndexDetailsPageRoute.bind(this)
    };
    return this.service;
  }
  addAction(action) {
    this._actions.push(action);
  }
  addBanner(banner) {
    this._banners.push(banner);
  }
  addFilter(filter) {
    this._filters.push(filter);
  }
  addBadge(badge) {
    this._badges.push(badge);
  }
  addToggle(toggle) {
    this._toggles.push(toggle);
  }
  addColumn(column) {
    this._columns.push(column);
  }
  setEmptyListContent(content) {
    if (this._emptyListContent) {
      throw new Error(`The empty list content has already been set.`);
    } else {
      this._emptyListContent = content;
    }
  }
  addIndexDetailsTab(tab) {
    this._indexDetailsTabs.push(tab);
  }
  setIndexOverviewContent(content) {
    if (this._indexOverviewContent) {
      throw new Error(`The content for index overview has already been set.`);
    } else {
      this._indexOverviewContent = content;
    }
  }
  setIndexMappingsContent(content) {
    if (this._indexMappingsContent) {
      throw new Error(`The content for index mappings has already been set.`);
    } else {
      this._indexMappingsContent = content;
    }
  }
  setIndexDetailsPageRoute(route) {
    if (this._indexDetailsPageRoute) {
      throw new Error(`The route for index details has already been set.`);
    } else {
      this._indexDetailsPageRoute = route;
    }
  }
  get actions() {
    return this._actions;
  }
  get banners() {
    return this._banners;
  }
  get filters() {
    return this._filters;
  }
  get badges() {
    return this._badges;
  }
  get toggles() {
    return this._toggles;
  }
  get columns() {
    return this._columns;
  }
  get emptyListContent() {
    return this._emptyListContent;
  }
  get indexDetailsTabs() {
    return this._indexDetailsTabs;
  }
  get indexOverviewContent() {
    return this._indexOverviewContent;
  }
  get indexMappingsContent() {
    return this._indexMappingsContent;
  }
  get indexDetailsPageRoute() {
    return this._indexDetailsPageRoute;
  }
}
exports.ExtensionsService = ExtensionsService;