"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MixedIndicesCallout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _ = require("../../../../..");
var _app_context = require("../../../../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MixedIndicesCallout = ({
  ilmPolicyLink,
  ilmPolicyName,
  dataStreamName,
  history
}) => {
  const {
    core
  } = (0, _app_context.useAppContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.someManagedByILMTitle', {
      defaultMessage: 'Some indices are managed by ILM'
    }),
    color: "warning",
    iconType: "warning",
    "data-test-subj": "someIndicesAreManagedByILMCallout"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.someManagedByILMBody",
    defaultMessage: "One or more indices are managed by an ILM policy ({viewAllIndicesLink}). Updating data retention for this data stream won't affect these indices. Instead you will have to update the {ilmPolicyLink} policy.",
    values: {
      ilmPolicyLink: ilmPolicyLink && ilmPolicyName && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "viewIlmPolicyLink",
        onClick: () => core.application.navigateToUrl(ilmPolicyLink)
      }, ilmPolicyName),
      viewAllIndicesLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(history, (0, _.getIndexListUri)(`data_stream="${dataStreamName}"`, true)), {
        "data-test-subj": "viewAllIndicesLink"
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.dataStreamsDetailsPanel.editDataRetentionModal.viewAllIndices",
        defaultMessage: "view indices"
      }))
    }
  })));
};
exports.MixedIndicesCallout = MixedIndicesCallout;