"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsList = void 0;
var _react = _interopRequireDefault(require("react"));
var _fields_list_item_container = require("./fields_list_item_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldsList = exports.FieldsList = /*#__PURE__*/_react.default.memo(function FieldsListComponent({
  fields,
  treeDepth,
  state,
  setPreviousState,
  isAddingFields,
  pendingFieldsRef
}) {
  if (fields === undefined) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("ul", {
    "data-test-subj": "fieldsList"
  }, fields.map((field, index) => /*#__PURE__*/_react.default.createElement(_fields_list_item_container.FieldsListItemContainer, {
    key: field.id,
    fieldId: field.id,
    treeDepth: treeDepth === undefined ? 0 : treeDepth,
    isLastItem: index === fields.length - 1,
    state: state,
    setPreviousState: setPreviousState,
    isAddingFields: isAddingFields,
    pendingFieldsRef: pendingFieldsRef
  })));
});