"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.splitSizeAndUnits = exports.hasLinkedIndices = exports.getPolicyByName = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const splitSizeAndUnits = field => {
  let size = '';
  let units = '';
  const result = /(\d+)(\w+)/.exec(field);
  if (result) {
    size = result[1];
    units = result[2];
  }
  return {
    size,
    units
  };
};
exports.splitSizeAndUnits = splitSizeAndUnits;
const getPolicyByName = (policies, policyName = '') => {
  if (policies && policies.length > 0) {
    return policies.find(policy => policy.name === policyName);
  }
};
exports.getPolicyByName = getPolicyByName;
const hasLinkedIndices = policy => Boolean(policy.indices && policy.indices.length);
exports.hasLinkedIndices = hasLinkedIndices;