"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidancePanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _state_management = require("../../state_management");
var _source_modal = require("../../services/source_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ListItem({
  children,
  state
}) {
  const isDisabled = state === 'disabled';
  return (
    /*#__PURE__*/
    // eslint-disable-next-line jsx-a11y/role-supports-aria-props
    _react.default.createElement("li", {
      css: [styles.listItem, isDisabled && styles.disabledListItem],
      "aria-disabled": isDisabled,
      "aria-current": state === 'active' ? 'step' : undefined
    }, !isDisabled && /*#__PURE__*/_react.default.createElement("span", {
      css: [styles.itemIcon, state === 'done' && styles.doneIcon],
      "aria-hidden": true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: state === 'active' ? 'sortRight' : 'check'
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, children))
  );
}
function GuidancePanelComponent(props) {
  const {
    onFillWorkspace,
    onOpenFieldPicker,
    onIndexPatternSelected,
    hasDatasource,
    hasFields
  } = props;
  const kibana = (0, _public.useKibana)();
  const {
    services,
    overlays
  } = kibana;
  const {
    application,
    data,
    contentManagement,
    uiSettings
  } = services;
  const [hasDataViews, setHasDataViews] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    const checkIfDataViewsExist = async () => {
      setHasDataViews(await data.dataViews.hasData.hasUserDataView());
    };
    checkIfDataViewsExist();
  }, [setHasDataViews, data.dataViews]);
  if (!overlays || !application) return null;
  const onOpenDatasourcePicker = () => {
    (0, _source_modal.openSourceModal)({
      overlays,
      contentManagement,
      uiSettings
    }, onIndexPatternSelected);
  };
  let content = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "graphGuidancePanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "graphApp",
    size: "xxl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("h1", {
    id: "graphHeading"
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.title', {
    defaultMessage: 'Three steps to your graph'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("ol", {
    css: styles.list,
    "aria-labelledby": "graphHeading"
  }, /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasDatasource ? 'done' : 'active'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onOpenDatasourcePicker
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.datasourceItem.indexPatternButtonLabel', {
    defaultMessage: 'Select a data source.'
  }))), /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasFields ? 'done' : hasDatasource ? 'active' : 'disabled'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: onOpenFieldPicker,
    disabled: !hasFields && !hasDatasource
  }, _i18n.i18n.translate('xpack.graph.guidancePanel.fieldsItem.fieldsButtonLabel', {
    defaultMessage: 'Add fields.'
  }))), /*#__PURE__*/_react.default.createElement(ListItem, {
    state: hasFields ? 'active' : 'disabled'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.graph.guidancePanel.nodesItem.description",
    defaultMessage: "Enter a query in the search bar to start exploring. Don't know where to start? {topTerms}.",
    values: {
      topTerms: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: onFillWorkspace,
        disabled: !hasFields
      }, _i18n.i18n.translate('xpack.graph.guidancePanel.nodesItem.topTermsButtonLabel', {
        defaultMessage: 'Graph the top terms'
      }))
    }
  }))))));
  if (!hasDataViews) {
    const dataViewManagementUrl = application.getUrlForApp('management', {
      path: '/kibana/dataViews'
    });
    const sampleDataUrl = `${application.getUrlForApp('home')}#/tutorial_directory/sampleData`;
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "question",
      title: _i18n.i18n.translate('xpack.graph.noDataSourceNotificationMessageTitle', {
        defaultMessage: 'No data source'
      }),
      heading: "h1"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, null, /*#__PURE__*/_react.default.createElement("p", {
      id: "graphHeading"
    }, _i18n.i18n.translate('xpack.graph.noDataSourceNotificationMessageTitle', {
      defaultMessage: 'No data source'
    }))), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.noDataSourceNotificationMessageText",
      defaultMessage: "No data sources found. Go to {managementIndexPatternsLink} and create a data view for your Elasticsearch indices.",
      values: {
        managementIndexPatternsLink: /*#__PURE__*/_react.default.createElement("a", {
          href: dataViewManagementUrl
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.graph.noDataSourceNotificationMessageText.managementDataViewLinkText",
          defaultMessage: "Management > Data views"
        }))
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.listing.noDataSource.newToKibanaDescription",
      defaultMessage: "New to Kibana? You can also use our {sampleDataInstallLink}.",
      values: {
        sampleDataInstallLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: sampleDataUrl
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.graph.listing.noDataSource.sampleDataInstallLinkText",
          defaultMessage: "sample data"
        }))
      }
    }))));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.guidancePanel
  }, content));
}
const GuidancePanel = exports.GuidancePanel = (0, _reactRedux.connect)(state => {
  return {
    hasDatasource: (0, _state_management.hasDatasourceSelector)(state),
    hasFields: (0, _state_management.hasFieldsSelector)(state)
  };
}, dispatch => ({
  onIndexPatternSelected: indexPattern => {
    dispatch((0, _state_management.requestDatasource)({
      type: 'indexpattern',
      id: indexPattern.id,
      title: indexPattern.attributes.title
    }));
  },
  onFillWorkspace: () => {
    dispatch((0, _state_management.fillWorkspace)());
  }
}))(GuidancePanelComponent);
const styles = {
  guidancePanel: ({
    euiTheme
  }) => (0, _react2.css)({
    maxWidth: '580px',
    margin: `${euiTheme.size.l} 0`
  }),
  list: (0, _react2.css)({
    listStyle: 'none',
    margin: '0',
    padding: '0'
  }),
  listItem: ({
    euiTheme
  }) => (0, _react2.css)({
    display: 'block',
    maxWidth: '420px',
    position: 'relative',
    paddingLeft: euiTheme.size.xl,
    marginBottom: euiTheme.size.l
  }),
  disabledListItem: ({
    euiTheme
  }) => (0, _react2.css)({
    color: euiTheme.colors.darkShade,
    button: {
      color: `${euiTheme.colors.darkShade} !important`
    }
  }),
  itemIcon: ({
    euiTheme
  }) => (0, _react2.css)({
    position: 'absolute',
    left: '0',
    top: `calc(-${euiTheme.size.xs} / 2)`,
    width: euiTheme.size.l,
    height: euiTheme.size.l,
    padding: euiTheme.size.xs
  }),
  doneIcon: ({
    euiTheme
  }) => (0, _react2.css)({
    backgroundColor: euiTheme.colors.success,
    color: euiTheme.colors.emptyShade,
    borderRadius: '50%'
  })
};