"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.populateMinimumRevisionsUsedByAgents = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const populateMinimumRevisionsUsedByAgents = async (esClient, policiesRevisionSummaries, context) => {
  var _result$aggregations;
  const result = await queryMinimumRevisionsUsedByAgents(esClient, Object.keys(policiesRevisionSummaries), context);
  (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.min_used_revisions_by_policy_id.buckets.forEach(bucket => {
    const policySummary = policiesRevisionSummaries[bucket.key];
    if (policySummary) {
      policySummary.minUsedRevision = bucket.min_used_revision.value;
    }
  });
  return policiesRevisionSummaries;
};
exports.populateMinimumRevisionsUsedByAgents = populateMinimumRevisionsUsedByAgents;
const queryMinimumRevisionsUsedByAgents = async (esClient, policyIds, context) => {
  var _context$abortControl;
  return await esClient.search({
    index: _common.AGENTS_INDEX,
    ignore_unavailable: true,
    size: 0,
    query: {
      terms: {
        policy_id: policyIds
      }
    },
    aggs: {
      min_used_revisions_by_policy_id: {
        terms: {
          field: 'policy_id',
          size: context.config.maxPolicies
        },
        aggs: {
          min_used_revision: {
            min: {
              field: 'policy_revision_idx'
            }
          }
        }
      }
    }
  }, {
    signal: (_context$abortControl = context.abortController) === null || _context$abortControl === void 0 ? void 0 : _context$abortControl.signal
  });
};