"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getPoliciesToClean = void 0;
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPoliciesToClean = async (esClient, context) => {
  var _results$aggregations, _results$aggregations2;
  const {
    config: {
      maxRevisions
    }
  } = context;
  const results = await queryMaxRevisionsAndCounts(esClient, context);
  return (_results$aggregations = (_results$aggregations2 = results.aggregations) === null || _results$aggregations2 === void 0 ? void 0 : _results$aggregations2.latest_revisions_by_policy_id.buckets.reduce((acc, bucket) => {
    if (bucket.doc_count > maxRevisions) {
      acc[bucket.key] = {
        maxRevision: bucket.latest_revision.value,
        count: bucket.doc_count
      };
    }
    return acc;
  }, {})) !== null && _results$aggregations !== void 0 ? _results$aggregations : {};
};
exports.getPoliciesToClean = getPoliciesToClean;
const queryMaxRevisionsAndCounts = async (esClient, context) => {
  var _context$abortControl;
  return await esClient.search({
    index: _common.AGENT_POLICY_INDEX,
    ignore_unavailable: true,
    size: 0,
    aggs: {
      latest_revisions_by_policy_id: {
        terms: {
          field: 'policy_id',
          order: {
            _count: 'desc'
          },
          size: context.config.maxPolicies
        },
        aggs: {
          latest_revision: {
            max: {
              field: 'revision_idx'
            }
          }
        }
      }
    }
  }, {
    signal: (_context$abortControl = context.abortController) === null || _context$abortControl === void 0 ? void 0 : _context$abortControl.signal
  });
};