"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackageServiceImpl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _common = require("@kbn/spaces-plugin/common");
var _http_authorization_header = require("../../../common/http_authorization_header");
var _security = require("../security");
var _errors = require("../../errors");
var _epm = require("../../routes/epm");
var _ = require("..");
var _registry = _interopRequireWildcard(require("./registry"));
var Registry = _registry;
var _install = require("./elasticsearch/transform/install");
var _packages = require("./packages");
var _archive = require("./archive");
var _storage = require("./archive/storage");
var _archive_iterator = require("./archive/archive_iterator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _classPrivateMethodInitSpec(e, a) { _checkPrivateRedeclaration(e, a), a.add(e); }
function _checkPrivateRedeclaration(e, t) { if (t.has(e)) throw new TypeError("Cannot initialize the same private elements twice on an object"); }
function _assertClassBrand(e, t, n) { if ("function" == typeof e ? e === t : e.has(t)) return arguments.length < 3 ? t : n; throw new TypeError("Private element is not present on this object"); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */ /* eslint-disable max-classes-per-file */
class PackageServiceImpl {
  constructor(internalEsClient, internalSoClient, logger) {
    this.internalEsClient = internalEsClient;
    this.internalSoClient = internalSoClient;
    this.logger = logger;
  }
  asScoped(request) {
    const preflightCheck = async requiredAuthz => {
      if (requiredAuthz) {
        const requestedAuthz = await (0, _security.getAuthzFromRequest)(request);
        const noRequiredAuthz = (0, _security.doesNotHaveRequiredFleetAuthz)(requestedAuthz, requiredAuthz);
        if (noRequiredAuthz) {
          throw new _errors.FleetUnauthorizedError(`User does not have adequate permissions to access Fleet packages.`);
        }
      } else if (!(0, _security.checkSuperuser)(request)) {
        throw new _errors.FleetUnauthorizedError(`User does not have adequate permissions to access Fleet packages.`);
      }
    };
    return new PackageClientImpl(this.internalEsClient, this.internalSoClient, this.logger, preflightCheck, request);
  }
  get asInternalUser() {
    return new PackageClientImpl(this.internalEsClient, this.internalSoClient, this.logger);
  }
}
exports.PackageServiceImpl = PackageServiceImpl;
var _PackageClientImpl_brand = /*#__PURE__*/new WeakSet();
class PackageClientImpl {
  constructor(internalEsClient, internalSoClient, logger, preflightCheck, request) {
    _classPrivateMethodInitSpec(this, _PackageClientImpl_brand);
    (0, _defineProperty2.default)(this, "authorizationHeader", undefined);
    this.internalEsClient = internalEsClient;
    this.internalSoClient = internalSoClient;
    this.logger = logger;
    this.preflightCheck = preflightCheck;
    this.request = request;
  }
  getAuthorizationHeader() {
    if (this.request) {
      this.authorizationHeader = _http_authorization_header.HTTPAuthorizationHeader.parseFromRequest(this.request);
      return this.authorizationHeader;
    }
  }
  async getInstallation(pkgName) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _packages.getInstallation)({
      pkgName,
      savedObjectsClient: this.internalSoClient
    });
  }
  async ensureInstalledPackage(options) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.INSTALL_PACKAGES_AUTHZ);
    return (0, _packages.ensureInstalledPackage)({
      ...options,
      esClient: this.internalEsClient,
      savedObjectsClient: this.internalSoClient
    });
  }
  async installPackage(options) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.INSTALL_PACKAGES_AUTHZ);
    const {
      pkgName,
      pkgVersion,
      spaceId = _common.DEFAULT_SPACE_ID,
      force = false
    } = options;

    // If pkgVersion isn't specified, find the latest package version
    const pkgKeyProps = pkgVersion ? {
      name: pkgName,
      version: pkgVersion
    } : await Registry.fetchFindLatestPackageOrThrow(pkgName, {
      prerelease: true
    });
    const pkgkey = Registry.pkgToPkgKey(pkgKeyProps);
    return await (0, _packages.installPackage)({
      force,
      pkgkey,
      spaceId,
      installSource: 'registry',
      esClient: this.internalEsClient,
      savedObjectsClient: this.internalSoClient,
      neverIgnoreVerificationError: !force
    });
  }
  async installCustomIntegration(options) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.INSTALL_PACKAGES_AUTHZ);
    const {
      pkgName,
      kibanaVersion = _.appContextService.getKibanaVersion(),
      datasets,
      spaceId = _common.DEFAULT_SPACE_ID,
      force = false
    } = options;
    return await (0, _packages.installPackage)({
      force,
      pkgName,
      kibanaVersion,
      datasets,
      spaceId,
      installSource: 'custom',
      esClient: this.internalEsClient,
      savedObjectsClient: this.internalSoClient,
      neverIgnoreVerificationError: !force,
      authorizationHeader: this.getAuthorizationHeader()
    });
  }
  async fetchFindLatestPackage(packageName, options) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _registry.fetchFindLatestPackageOrThrow)(packageName, options);
  }
  async readBundledPackage(bundledPackage) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    const archiveBuffer = await bundledPackage.getBuffer();
    return (0, _archive.generatePackageInfoFromArchiveBuffer)(archiveBuffer, 'application/zip');
  }
  async getAgentPolicyConfigYAML(pkgName, pkgVersion, prerelease, ignoreUnverified) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);

    // If pkgVersion isn't specified, find the latest package version
    if (!pkgVersion) {
      const pkg = await Registry.fetchFindLatestPackageOrThrow(pkgName, {
        prerelease
      });
      pkgVersion = pkg.version;
    }
    return (0, _packages.getTemplateInputs)(this.internalSoClient, pkgName, pkgVersion, 'yml', prerelease, ignoreUnverified);
  }
  async getPackage(packageName, packageVersion, options) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _registry.getPackage)(packageName, packageVersion, options);
  }
  async getPackageFieldsMetadata(params, options) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _registry.getPackageFieldsMetadata)(params, options);
  }
  async getLatestPackageInfo(packageName, prerelease) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _packages.getPackageInfo)({
      savedObjectsClient: this.internalSoClient,
      pkgName: packageName,
      pkgVersion: '',
      prerelease
    });
  }
  async getPackages(params) {
    const {
      excludeInstallStatus,
      category,
      prerelease
    } = params || {};
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.READ_PACKAGE_INFO_AUTHZ);
    return (0, _packages.getPackages)({
      savedObjectsClient: this.internalSoClient,
      excludeInstallStatus,
      category,
      prerelease
    });
  }
  async reinstallEsAssets(packageInfo, assetPaths) {
    await _assertClassBrand(_PackageClientImpl_brand, this, _runPreflight).call(this, _epm.INSTALL_PACKAGES_AUTHZ);
    let installedAssets = [];
    const transformPaths = assetPaths.filter(_install.isTransform);
    if (transformPaths.length !== assetPaths.length) {
      throw new _errors.FleetError('reinstallEsAssets is currently only implemented for transform assets');
    }
    if (transformPaths.length) {
      const installedTransformAssets = await _assertClassBrand(_PackageClientImpl_brand, this, _reinstallTransforms).call(this, packageInfo, transformPaths);
      installedAssets = [...installedAssets, ...installedTransformAssets];
    }
    return installedAssets;
  }
}
async function _reinstallTransforms(packageInfo, paths) {
  var _installation$package;
  const authorizationHeader = this.getAuthorizationHeader();
  const installation = await this.getInstallation(packageInfo.name);
  if (!installation) {
    throw new _errors.PackageNotFoundError(`Installation not found for package: ${packageInfo.name}`);
  }
  const esPackage = await (0, _storage.getEsPackage)(packageInfo.name, packageInfo.version, (_installation$package = installation.package_assets) !== null && _installation$package !== void 0 ? _installation$package : [], this.internalSoClient);
  if (!esPackage) {
    throw new _errors.PackageNotFoundError(`ES package not found for package: ${packageInfo.name}`);
  }
  const {
    assetsMap
  } = esPackage;
  const archiveIterator = (0, _archive_iterator.createArchiveIteratorFromMap)(assetsMap);
  const {
    installedTransforms
  } = await (0, _install.installTransforms)({
    packageInstallContext: {
      assetsMap,
      packageInfo,
      paths,
      archiveIterator
    },
    esClient: this.internalEsClient,
    savedObjectsClient: this.internalSoClient,
    logger: this.logger,
    force: true,
    esReferences: undefined,
    authorizationHeader
  });
  return installedTransforms;
}
async function _runPreflight(requiredAuthz) {
  if (this.preflightCheck) {
    return await this.preflightCheck(requiredAuthz);
  }
}