"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _security = require("../../services/security");
var _constants = require("../../../common/constants");
var _constants2 = require("../../constants");
var _types = require("../../types");
var _security2 = require("../../services/security/security");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // List
  router.versioned.get({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.LIST_PATTERN,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('get', _constants2.PACKAGE_POLICY_API_ROUTES.LIST_PATTERN)).granted,
    summary: 'Get package policies',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetPackagePoliciesRequestSchema
    }
  }, _handlers.getPackagePoliciesHandler);

  // Get bulk
  router.versioned.post({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.BULK_GET_PATTERN,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('post', _constants2.PACKAGE_POLICY_API_ROUTES.BULK_GET_PATTERN)).granted,
    summary: 'Bulk get package policies',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.BulkGetPackagePoliciesRequestSchema
    }
  }, _handlers.bulkGetPackagePoliciesHandler);

  // Get one
  router.versioned.get({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.INFO_PATTERN,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('get', _constants2.PACKAGE_POLICY_API_ROUTES.INFO_PATTERN)).granted,
    summary: 'Get a package policy',
    description: 'Get a package policy by ID.',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.GetOnePackagePolicyRequestSchema
    }
  }, _handlers.getOnePackagePolicyHandler);
  router.versioned.get({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.ORPHANED_INTEGRATION_POLICIES,
    fleetAuthz: {
      integrations: {
        readIntegrationPolicies: true
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {}
  }, _handlers.getOrphanedPackagePolicies);

  // Create
  router.versioned.post({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.CREATE_PATTERN,
    summary: 'Create a package policy',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.CreatePackagePolicyRequestSchema
    }
  }, _handlers.createPackagePolicyHandler);

  // Update
  router.versioned.put({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.UPDATE_PATTERN,
    fleetAuthz: fleetAuthz => (0, _security2.calculateRouteAuthz)(fleetAuthz, (0, _security.getRouteRequiredAuthz)('put', _constants2.PACKAGE_POLICY_API_ROUTES.UPDATE_PATTERN)).granted,
    summary: 'Update a package policy',
    description: 'Update a package policy by ID.',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.UpdatePackagePolicyRequestSchema
    }
  }, _handlers.updatePackagePolicyHandler);

  // Delete (bulk)
  router.versioned.post({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.DELETE_PATTERN,
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    },
    summary: 'Bulk delete package policies',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeletePackagePoliciesRequestSchema
    }
  }, _handlers.deletePackagePolicyHandler);
  router.versioned.delete({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.INFO_PATTERN,
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    },
    summary: 'Delete a package policy',
    description: 'Delete a package policy by ID.',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DeleteOnePackagePolicyRequestSchema
    }
  }, _handlers.deleteOnePackagePolicyHandler);

  // Upgrade
  router.versioned.post({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.UPGRADE_PATTERN,
    fleetAuthz: {
      integrations: {
        writeIntegrationPolicies: true
      }
    },
    summary: 'Upgrade a package policy',
    description: 'Upgrade a package policy to a newer package version.',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.UpgradePackagePoliciesRequestSchema
    }
  }, _handlers.upgradePackagePolicyHandler);

  // Upgrade - DryRun
  router.versioned.post({
    path: _constants2.PACKAGE_POLICY_API_ROUTES.DRYRUN_PATTERN,
    fleetAuthz: {
      integrations: {
        readIntegrationPolicies: true
      }
    },
    summary: 'Dry run a package policy upgrade',
    options: {
      tags: ['oas-tag:Fleet package policies']
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {
      request: _types.DryRunPackagePoliciesRequestSchema
    }
  }, _handlers.dryRunUpgradePackagePolicyHandler);
};
exports.registerRoutes = registerRoutes;