"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.canUseMultipleAgentPolicies = canUseMultipleAgentPolicies;
exports.useMultipleAgentPolicies = useMultipleAgentPolicies;
var _constants = require("../../common/constants");
var _services = require("../services");
var _use_license = require("./use_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useMultipleAgentPolicies() {
  return {
    canUseMultipleAgentPolicies: canUseMultipleAgentPolicies()
  };
}
function canUseMultipleAgentPolicies() {
  const {
    enableReusableIntegrationPolicies
  } = _services.ExperimentalFeaturesService.get();
  const hasEnterpriseLicence = _use_license.licenseService.hasAtLeast(_constants.LICENCE_FOR_MULTIPLE_AGENT_POLICIES);
  return Boolean(enableReusableIntegrationPolicies && hasEnterpriseLicence);
}