"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigContext = void 0;
exports.useConfig = useConfig;
var _react = _interopRequireWildcard(require("react"));
var _ = require(".");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigContext = exports.ConfigContext = /*#__PURE__*/_react.default.createContext(null);
function useConfig() {
  const {
    fleet
  } = (0, _.useStartServices)();
  const baseConfig = (0, _react.useContext)(ConfigContext);

  // Downstream plugins may set `fleet` as part of the Kibana context
  // which means that the Fleet config is exposed in that way
  const pluginConfig = fleet === null || fleet === void 0 ? void 0 : fleet.config;
  const config = baseConfig || pluginConfig || null;
  if (baseConfig === null && pluginConfig) {
    // eslint-disable-next-line no-console
    console.warn('Fleet ConfigContext not initialized, using from plugin context');
  }
  if (!config) {
    throw new Error('Fleet ConfigContext not initialized');
  }
  return config;
}