"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricNonAvailable = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetricNonAvailable = ({
  agentPolicy
}) => {
  var _agentPolicy$monitori;
  const isMonitoringEnabled = agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$monitori = agentPolicy.monitoring_enabled) === null || _agentPolicy$monitori === void 0 ? void 0 : _agentPolicy$monitori.includes('metrics');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, "N/A")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    content: !isMonitoringEnabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agent.metricsNotAvailableMonitoringNotEnabled",
      defaultMessage: "Agent monitoring is not enabled for this agent policy. Visit agent policy settings to enable monitoring."
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.metricsNotAvailableOtherReason",
      defaultMessage: "That metric is not available, you may not have the correct permission to retrieve them."
    }),
    color: "subdued"
  })));
};
exports.MetricNonAvailable = MetricNonAvailable;