"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActivitySection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _upgrade_in_progress_activity_item = require("./upgrade_in_progress_activity_item");
var _activity_item = require("./activity_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ActivitySection = ({
  title,
  actions,
  abortUpgrade,
  onClickViewAgents,
  onClickManageAutoUpgradeAgents
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: true,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center"
  }, actions.some(action => action.status === 'IN_PROGRESS') && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: "success"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement("b", null, title))))), actions.map(currentAction => currentAction.type === 'UPGRADE' && currentAction.status === 'IN_PROGRESS' ? /*#__PURE__*/_react.default.createElement(_upgrade_in_progress_activity_item.UpgradeInProgressActivityItem, {
    action: currentAction,
    abortUpgrade: abortUpgrade,
    key: currentAction.actionId,
    onClickViewAgents: onClickViewAgents,
    onClickManageAutoUpgradeAgents: onClickManageAutoUpgradeAgents
  }) : /*#__PURE__*/_react.default.createElement(_activity_item.ActivityItem, {
    action: currentAction,
    key: currentAction.actionId,
    onClickViewAgents: onClickViewAgents,
    onClickManageAutoUpgradeAgents: onClickManageAutoUpgradeAgents
  })));
};
exports.ActivitySection = ActivitySection;