"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getNewSecrets = void 0;
var _services = require("../../../../../../../common/services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getNewSecrets = ({
  packageInfo,
  packagePolicy
}) => {
  const result = [];
  for (const packageVar of (_packageInfo$vars = packageInfo.vars) !== null && _packageInfo$vars !== void 0 ? _packageInfo$vars : []) {
    var _packageInfo$vars, _packagePolicy$vars, _packagePolicy$vars$p, _packagePolicy$vars$p2;
    const isVarSecretOnPolicy = (_packagePolicy$vars = packagePolicy.vars) === null || _packagePolicy$vars === void 0 ? void 0 : (_packagePolicy$vars$p = _packagePolicy$vars[packageVar.name]) === null || _packagePolicy$vars$p === void 0 ? void 0 : (_packagePolicy$vars$p2 = _packagePolicy$vars$p.value) === null || _packagePolicy$vars$p2 === void 0 ? void 0 : _packagePolicy$vars$p2.isSecretRef;
    if (packageVar.secret && !isVarSecretOnPolicy) {
      result.push(packageVar);
    }
  }
  for (const policyTemplate of (_packageInfo$policy_t = packageInfo.policy_templates) !== null && _packageInfo$policy_t !== void 0 ? _packageInfo$policy_t : []) {
    var _packageInfo$policy_t;
    if ((0, _services.isInputOnlyPolicyTemplate)(policyTemplate)) {
      for (const packageVar of (_policyTemplate$vars = policyTemplate.vars) !== null && _policyTemplate$vars !== void 0 ? _policyTemplate$vars : []) {
        var _policyTemplate$vars, _packagePolicy$inputs, _packagePolicy$inputs2, _packagePolicy$inputs3, _packagePolicy$inputs4, _packagePolicy$inputs5;
        const isVarSecretOnPolicy = (_packagePolicy$inputs = packagePolicy.inputs) === null || _packagePolicy$inputs === void 0 ? void 0 : (_packagePolicy$inputs2 = _packagePolicy$inputs[0]) === null || _packagePolicy$inputs2 === void 0 ? void 0 : (_packagePolicy$inputs3 = _packagePolicy$inputs2.vars) === null || _packagePolicy$inputs3 === void 0 ? void 0 : (_packagePolicy$inputs4 = _packagePolicy$inputs3[packageVar.name]) === null || _packagePolicy$inputs4 === void 0 ? void 0 : (_packagePolicy$inputs5 = _packagePolicy$inputs4.value) === null || _packagePolicy$inputs5 === void 0 ? void 0 : _packagePolicy$inputs5.isSecretRef;
        if (packageVar.secret && !isVarSecretOnPolicy) {
          result.push(packageVar);
        }
      }
    } else {
      for (const input of (_policyTemplate$input = policyTemplate.inputs) !== null && _policyTemplate$input !== void 0 ? _policyTemplate$input : []) {
        var _policyTemplate$input;
        for (const packageVar of (_input$vars = input.vars) !== null && _input$vars !== void 0 ? _input$vars : []) {
          var _input$vars, _packagePolicy$inputs6, _packagePolicy$inputs7, _packagePolicy$inputs8, _packagePolicy$inputs9, _packagePolicy$inputs10;
          const isVarSecretOnPolicy = (_packagePolicy$inputs6 = packagePolicy.inputs) === null || _packagePolicy$inputs6 === void 0 ? void 0 : (_packagePolicy$inputs7 = _packagePolicy$inputs6[0]) === null || _packagePolicy$inputs7 === void 0 ? void 0 : (_packagePolicy$inputs8 = _packagePolicy$inputs7.vars) === null || _packagePolicy$inputs8 === void 0 ? void 0 : (_packagePolicy$inputs9 = _packagePolicy$inputs8[packageVar.name]) === null || _packagePolicy$inputs9 === void 0 ? void 0 : (_packagePolicy$inputs10 = _packagePolicy$inputs9.value) === null || _packagePolicy$inputs10 === void 0 ? void 0 : _packagePolicy$inputs10.isSecretRef;
          if (packageVar.secret && !isVarSecretOnPolicy) {
            result.push(packageVar);
          }
        }
      }
    }
  }
  return result;
};
exports.getNewSecrets = getNewSecrets;