"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageAutoUpgradeAgentsBadge = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManageAutoUpgradeAgentsBadge = ({
  agentPolicy,
  isManageAutoUpgradeAgentsModalOpen,
  setIsManageAutoUpgradeAgentsModalOpen
}) => {
  var _agentPolicy$required, _agentPolicy$required2, _agentPolicy$required3;
  const {
    data: autoUpgradeAgentsStatus
  } = (0, _hooks.useGetAutoUpgradeAgentsStatusQuery)(agentPolicy.id);
  const requiredVersions = ((_agentPolicy$required = agentPolicy.required_versions) !== null && _agentPolicy$required !== void 0 ? _agentPolicy$required : []).map(reqVersion => reqVersion.version);
  const hasErrors = (0, _react.useMemo)(() => {
    return autoUpgradeAgentsStatus === null || autoUpgradeAgentsStatus === void 0 ? void 0 : autoUpgradeAgentsStatus.currentVersions.filter(value => requiredVersions.includes(value.version)).some(value => value.failedUpgradeAgents > 0);
  }, [autoUpgradeAgentsStatus, requiredVersions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center",
    id: "auto-upgrade-manage-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      setIsManageAutoUpgradeAgentsModalOpen(!isManageAutoUpgradeAgentsModalOpen);
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.summary.autoUpgradeButton",
    defaultMessage: "Manage"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
    color: (_agentPolicy$required2 = agentPolicy.required_versions) !== null && _agentPolicy$required2 !== void 0 && _agentPolicy$required2.length ? 'accent' : 'subdued'
  }, ((_agentPolicy$required3 = agentPolicy.required_versions) === null || _agentPolicy$required3 === void 0 ? void 0 : _agentPolicy$required3.length) || 0)), hasErrors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.manageAutoUpgradeAgents.failedUpgradeTooltip",
      defaultMessage: "Some agents failed to upgrade, click on Manage to see details."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "danger"
  }))));
};
exports.ManageAutoUpgradeAgentsBadge = ManageAutoUpgradeAgentsBadge;