"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgentPageStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _confirm_agent_enrollment = require("../../../../../../../../../components/agent_enrollment_flyout/confirm_agent_enrollment");
var _install_agent_managed = require("./install_agent_managed");
var _install_agent_standalone = require("./install_agent_standalone");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InstallElasticAgentPageStep = props => {
  var _props$agentPolicy;
  const [localIsManaged, setLocalIsManaged] = (0, _react.useState)(props.isManaged);
  const [useLocalState, setUseLocalState] = (0, _react.useState)(false);
  const {
    enrolledAgentIds
  } = (0, _confirm_agent_enrollment.usePollingAgentCount)(((_props$agentPolicy = props.agentPolicy) === null || _props$agentPolicy === void 0 ? void 0 : _props$agentPolicy.id) || '', {
    noLowerTimeLimit: true,
    pollImmediately: true
  });
  const onNext = () => {
    props.setEnrolledAgentIds(enrolledAgentIds);
    props.onNext();
  };
  const managedPageProps = {
    ...props,
    onNext,
    enrolledAgentIds,
    setIsManaged: useLocalState ? setLocalIsManaged : props.setIsManaged
  };
  if (localIsManaged) {
    return /*#__PURE__*/_react.default.createElement(_install_agent_managed.InstallElasticAgentManagedPageStep, managedPageProps);
  }
  const standalonePageProps = {
    ...props,
    onNext,
    enrolledAgentIds,
    setIsManaged: newIsManaged => {
      if (newIsManaged) {
        // once you are in the standalone set of steps and the package policy
        // has been created, there is no going back to the managed steps.
        // instead only this page view is toggled.
        setUseLocalState(true);
      }
      setLocalIsManaged(newIsManaged);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_install_agent_standalone.InstallElasticAgentStandalonePageStep, standalonePageProps);
};
exports.InstallElasticAgentPageStep = InstallElasticAgentPageStep;