"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetAutoUpgradeAgentsStatusResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GetAutoUpgradeAgentsStatusResponseSchema = exports.GetAutoUpgradeAgentsStatusResponseSchema = _configSchema.schema.object({
  currentVersions: _configSchema.schema.arrayOf(_configSchema.schema.object({
    version: _configSchema.schema.string({
      meta: {
        description: 'Agent version'
      }
    }),
    agents: _configSchema.schema.number({
      meta: {
        description: 'Number of agents that upgraded to this version'
      }
    }),
    failedUpgradeAgents: _configSchema.schema.number({
      meta: {
        description: 'Number of agents that failed to upgrade to this version'
      }
    }),
    failedUpgradeActionIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
      meta: {
        description: 'List of action IDs related to failed upgrades'
      }
    })),
    inProgressUpgradeAgents: _configSchema.schema.number({
      meta: {
        description: 'Number of agents that are upgrading to this version'
      }
    }),
    inProgressUpgradeActionIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string(), {
      meta: {
        description: 'List of action IDs related to in-progress upgrades'
      }
    }))
  })),
  totalAgents: _configSchema.schema.number()
});