"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TikaImporter = void 0;
var _base64Js = require("base64-js");
var _importer = require("./importer");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TikaImporter extends _importer.Importer {
  constructor() {
    super();
  }
  read(data) {
    this._chunkSize = 0;
    const pdfBase64 = (0, _base64Js.fromByteArray)(new Uint8Array(data));
    const {
      success,
      docs
    } = this._createDocs(pdfBase64);
    if (success) {
      this._docArray = this._docArray.concat(docs);
    } else {
      return {
        success: false
      };
    }
    return {
      success: true
    };
  }
  _createDocs(base64String) {
    const remainder = 0;
    try {
      const docs = [{
        data: base64String
      }];
      return {
        success: true,
        docs,
        remainder
      };
    } catch (error) {
      return {
        success: false,
        docs: [],
        remainder,
        error
      };
    }
  }
}
exports.TikaImporter = TikaImporter;