"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecondaryMetric = SecondaryMetric;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _utils = require("@kbn/visualizations-plugin/common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const notAvailable = _i18n.i18n.translate('expressionMetricVis.secondaryMetric.notAvailable', {
  defaultMessage: 'N/A'
});
function getDeltaValue(rawValue, baselineValue) {
  // Return NAN delta for now if either side of the formula is not a number
  if (rawValue == null || baselineValue == null || !Number.isFinite(baselineValue)) {
    return NaN;
  }
  return rawValue - baselineValue;
}
function getBadgeConfiguration(trendConfig, deltaValue) {
  if (Number.isNaN(deltaValue)) {
    return {
      icon: undefined,
      iconLabel: notAvailable,
      color: trendConfig.palette[1]
    };
  }
  if (deltaValue < 0) {
    return {
      icon: trendConfig.icon ? '\u{2193}' : undefined,
      // ↓
      iconLabel: _i18n.i18n.translate('expressionMetricVis.secondaryMetric.trend.decrease', {
        defaultMessage: 'downward direction'
      }),
      color: trendConfig.palette[0]
    };
  }
  if (deltaValue > 0) {
    return {
      icon: trendConfig.icon ? '\u{2191}' : undefined,
      // ↑
      iconLabel: _i18n.i18n.translate('expressionMetricVis.secondaryMetric.trend.increase', {
        defaultMessage: 'upward direction'
      }),
      color: trendConfig.palette[2]
    };
  }
  return {
    icon: trendConfig.icon ? '\u{003D}' : undefined,
    // =
    iconLabel: _i18n.i18n.translate('expressionMetricVis.secondaryMetric.trend.stable', {
      defaultMessage: 'stable'
    }),
    color: trendConfig.palette[1]
  };
}
function getValueToShow(value, deltaValue, formatter, compareToPrimary) {
  // In comparison mode the NaN delta should be converted to N/A
  if (compareToPrimary) {
    var _formatter;
    if (Number.isNaN(deltaValue)) {
      return notAvailable;
    }
    return (_formatter = formatter === null || formatter === void 0 ? void 0 : formatter(deltaValue)) !== null && _formatter !== void 0 ? _formatter : String(deltaValue);
  }
  return String(value);
}
function getTrendDescription(showValue, hasIcon, value, direction) {
  if (showValue) {
    return undefined;
  }
  if (hasIcon) {
    return _i18n.i18n.translate('expressionMetricVis.secondaryMetric.trend', {
      defaultMessage: 'Value: {value} - Changed to {direction}',
      values: {
        value,
        direction
      }
    });
  }
  return _i18n.i18n.translate('expressionMetricVis.secondaryMetric.trendnoDifferences', {
    defaultMessage: 'Value: {value} - No differences',
    values: {
      value
    }
  });
}
function SecondaryMetricValue({
  rawValue,
  formattedValue,
  trendConfig,
  color,
  formatter
}) {
  const safeFormattedValue = formattedValue !== null && formattedValue !== void 0 ? formattedValue : notAvailable;
  const badgeCss = (0, _react2.css)(`
    font-size:  inherit;
    line-height:  inherit;
    ${trendConfig && typeof rawValue === 'number' ? `border: 1px solid ${trendConfig.borderColor};` : ''}
  `);
  if (trendConfig && (typeof rawValue === 'number' || rawValue == null)) {
    // When comparing with primary metric we want to change the order of the difference (primary - secondary)
    const deltaFactor = trendConfig.compareToPrimary ? -1 : 1;
    const deltaValue = deltaFactor * getDeltaValue(rawValue, trendConfig.baselineValue);
    const {
      icon,
      color: trendColor,
      iconLabel
    } = getBadgeConfiguration(trendConfig, deltaValue);
    const valueToShow = getValueToShow(safeFormattedValue, deltaValue, formatter, trendConfig.compareToPrimary);
    // If no value is shown and no icon should be shown (i.e. N/A) then do not render the badge at all
    if (trendConfig.icon && !trendConfig.value && !icon) {
      return /*#__PURE__*/_react.default.createElement("span", {
        "data-test-subj": `expressionMetricVis-secondaryMetric-badge-${rawValue}`,
        "aria-label": getTrendDescription(trendConfig.value, icon != null, valueToShow, iconLabel)
      });
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      "aria-label":
      // Make the information accessible also for screen readers
      // so show it only when icon only mode to avoid to be reduntant
      getTrendDescription(trendConfig.value, icon != null, valueToShow, iconLabel),
      color: trendColor,
      "data-test-subj": `expressionMetricVis-secondaryMetric-badge-${rawValue}`,
      css: badgeCss
    }, trendConfig.value ? valueToShow : null, trendConfig.value && trendConfig.icon && icon ? ' ' : '', trendConfig.icon && icon ? icon : null);
  }
  if (color) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: color,
      "data-test-subj": `expressionMetricVis-secondaryMetric-badge-${rawValue}`,
      css: badgeCss
    }, safeFormattedValue);
  }
  return formattedValue !== null && formattedValue !== void 0 ? formattedValue : null;
}
function getMetricColumnAndFormatter(columns, config, getMetricFormatter, formatOverrides) {
  if (!config.dimensions.secondaryMetric) {
    return;
  }
  return {
    metricColumn: (0, _utils.getColumnByAccessor)(config.dimensions.secondaryMetric, columns),
    metricFormatter: getMetricFormatter(config.dimensions.secondaryMetric, columns, formatOverrides)
  };
}
function getEnhancedNumberSignFormatter(trendConfig) {
  if (!(trendConfig !== null && trendConfig !== void 0 && trendConfig.compareToPrimary)) {
    return;
  }
  const paramsOverride = {
    alwaysShowSign: true
  };
  return {
    number: paramsOverride,
    percent: paramsOverride,
    bytes: paramsOverride
  };
}
function SecondaryMetric({
  columns,
  row,
  config,
  getMetricFormatter,
  trendConfig,
  color
}) {
  var _config$metric$second;
  const {
    metricFormatter,
    metricColumn
  } = getMetricColumnAndFormatter(columns, config, getMetricFormatter, getEnhancedNumberSignFormatter(trendConfig)) || {};
  const prefix = (_config$metric$second = config.metric.secondaryPrefix) !== null && _config$metric$second !== void 0 ? _config$metric$second : metricColumn === null || metricColumn === void 0 ? void 0 : metricColumn.name;
  const value = metricColumn ? row[metricColumn.id] : undefined;
  return /*#__PURE__*/_react.default.createElement("span", {
    css: styles.wrapper,
    "data-test-subj": "metric-secondary-element"
  }, prefix && /*#__PURE__*/_react.default.createElement("span", {
    css: styles.prefix
  }, prefix), /*#__PURE__*/_react.default.createElement("span", {
    css: styles.value
  }, /*#__PURE__*/_react.default.createElement(SecondaryMetricValue, {
    rawValue: value,
    formattedValue: metricFormatter === null || metricFormatter === void 0 ? void 0 : metricFormatter(value),
    trendConfig: color ? undefined : trendConfig,
    color: color,
    formatter: metricFormatter
  })));
}
const styles = {
  wrapper: (0, _react2.css)({
    display: 'flex',
    alignItems: 'center',
    minWidth: 0,
    width: '100%',
    overflow: 'hidden',
    whiteSpace: 'nowrap'
  }),
  prefix: (0, _react2.css)({
    flex: '0 1 auto',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap'
  }),
  value: (0, _react2.css)({
    display: 'inline-flex',
    flex: '1 0 auto',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    whiteSpace: 'nowrap',
    minWidth: 0,
    marginLeft: 4,
    maxWidth: 'calc(100% - 4px)' // Subtract the marginLeft value
  })
};