"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsSuggestionsAfter = void 0;
var _lodash = require("lodash");
var _esqlAst = require("@kbn/esql-ast");
var _helpers = require("../../../shared/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const fieldsSuggestionsAfter = (command, previousCommandFields, userDefinedColumns) => {
  const columns = [];
  (0, _esqlAst.walk)(command, {
    visitCommandOption: node => {
      const args = node.args.filter(_helpers.isColumnItem);
      const breakdownColumns = args.map(arg => arg.name);
      columns.push(...breakdownColumns);
    }
  });
  const columnsToKeep = previousCommandFields.filter(field => {
    return columns.some(column => column === field.name);
  });
  return (0, _lodash.uniqBy)([...columnsToKeep, ...userDefinedColumns], 'name');
};
exports.fieldsSuggestionsAfter = fieldsSuggestionsAfter;