"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createForkCommand = void 0;
var _esql_parser = require("../../antlr/esql_parser");
var _builder = require("../../builder");
var _factories = require("../factories");
var _dissect = require("./dissect");
var _eval = require("./eval");
var _limit = require("./limit");
var _sort = require("./sort");
var _stats = require("./stats");
var _where = require("./where");
var _completion = require("./completion");
var _change_point = require("./change_point");
var _grok = require("./grok");
var _keep = require("./keep");
var _mv_expand = require("./mv_expand");
var _drop = require("./drop");
var _rename = require("./rename");
var _enrich = require("./enrich");
var _sample = require("./sample");
var _join = require("./join");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const createForkCommand = ctx => {
  const command = (0, _factories.createCommand)('fork', ctx);
  const subQueryContexts = ctx.forkSubQueries().forkSubQuery_list();
  for (const subCtx of subQueryContexts) {
    const subCommands = visitForkSubQueryContext(subCtx.forkSubQueryCommand());
    const branch = _builder.Builder.expression.query(subCommands, (0, _factories.createParserFields)(subCtx));
    command.args.push(branch);
  }
  return command;
};
exports.createForkCommand = createForkCommand;
function visitForkSubQueryContext(ctx) {
  const commands = [];
  let nextCtx = ctx;
  while (nextCtx instanceof _esql_parser.CompositeForkSubQueryContext) {
    const command = visitForkSubQueryProcessingCommandContext(nextCtx.forkSubQueryProcessingCommand());
    if (command) {
      commands.unshift(command);
    }
    nextCtx = nextCtx.forkSubQueryCommand();
  }
  if (nextCtx instanceof _esql_parser.SingleForkSubQueryCommandContext) {
    const command = visitForkSubQueryProcessingCommandContext(nextCtx.forkSubQueryProcessingCommand());
    if (command) {
      commands.unshift(command);
    }
  }
  return commands;
}
function visitForkSubQueryProcessingCommandContext(ctx) {
  const whereCtx = ctx.processingCommand().whereCommand();
  if (whereCtx) {
    return (0, _where.createWhereCommand)(whereCtx);
  }
  const sortCtx = ctx.processingCommand().sortCommand();
  if (sortCtx) {
    return (0, _sort.createSortCommand)(sortCtx);
  }
  const limitCtx = ctx.processingCommand().limitCommand();
  if (limitCtx) {
    return (0, _limit.createLimitCommand)(limitCtx);
  }
  const dissectCtx = ctx.processingCommand().dissectCommand();
  if (dissectCtx) {
    return (0, _dissect.createDissectCommand)(dissectCtx);
  }
  const evalCtx = ctx.processingCommand().evalCommand();
  if (evalCtx) {
    return (0, _eval.createEvalCommand)(evalCtx);
  }
  const statsCtx = ctx.processingCommand().statsCommand();
  if (statsCtx) {
    return (0, _stats.createStatsCommand)(statsCtx);
  }
  const grokCtx = ctx.processingCommand().grokCommand();
  if (grokCtx) {
    return (0, _grok.createGrokCommand)(grokCtx);
  }
  const changePointCtx = ctx.processingCommand().changePointCommand();
  if (changePointCtx) {
    return (0, _change_point.createChangePointCommand)(changePointCtx);
  }
  const completionCtx = ctx.processingCommand().completionCommand();
  if (completionCtx) {
    return (0, _completion.createCompletionCommand)(completionCtx);
  }
  const mvExpandCtx = ctx.processingCommand().mvExpandCommand();
  if (mvExpandCtx) {
    return (0, _mv_expand.createMvExpandCommand)(mvExpandCtx);
  }
  const keepCtx = ctx.processingCommand().keepCommand();
  if (keepCtx) {
    return (0, _keep.createKeepCommand)(keepCtx);
  }
  const dropCtx = ctx.processingCommand().dropCommand();
  if (dropCtx) {
    return (0, _drop.createDropCommand)(dropCtx);
  }
  const renameCtx = ctx.processingCommand().renameCommand();
  if (renameCtx) {
    return (0, _rename.createRenameCommand)(renameCtx);
  }
  const enrichCtx = ctx.processingCommand().enrichCommand();
  if (enrichCtx) {
    return (0, _enrich.createEnrichCommand)(enrichCtx);
  }
  const sampleCtx = ctx.processingCommand().sampleCommand();
  if (sampleCtx) {
    return (0, _sample.createSampleCommand)(sampleCtx);
  }
  const joinCtx = ctx.processingCommand().joinCommand();
  if (joinCtx) {
    return (0, _join.createJoinCommand)(joinCtx);
  }
}