"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteLatestTransform = deleteLatestTransform;
exports.deleteTransforms = deleteTransforms;
var _retry = require("./helpers/retry");
var _generate_component_id = require("./helpers/generate_component_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function deleteTransforms(esClient, definition, logger) {
  try {
    var _definition$installed;
    await Promise.all(((_definition$installed = definition.installedComponents) !== null && _definition$installed !== void 0 ? _definition$installed : []).filter(({
      type
    }) => type === 'transform').map(({
      id
    }) => (0, _retry.retryTransientEsErrors)(() => esClient.transform.deleteTransform({
      transform_id: id,
      force: true
    }, {
      ignore: [404]
    }), {
      logger
    })));
  } catch (e) {
    logger.error(`Cannot delete transforms for definition [${definition.id}]: ${e}`);
    throw e;
  }
}
async function deleteLatestTransform(esClient, definition, logger) {
  try {
    await (0, _retry.retryTransientEsErrors)(() => esClient.transform.deleteTransform({
      transform_id: (0, _generate_component_id.generateLatestTransformId)(definition),
      force: true
    }, {
      ignore: [404]
    }), {
      logger
    });
  } catch (e) {
    logger.error(`Cannot delete latest transform for definition [${definition.id}]: ${e}`);
    throw e;
  }
}