"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ENTITY_SCHEMA_VERSION_V1 = exports.ENTITY_LATEST = exports.ENTITY_HISTORY = exports.ENTITY_BASE_PREFIX = void 0;
exports.entitiesAliasPattern = entitiesAliasPattern;
exports.entitiesIndexPattern = entitiesIndexPattern;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_BASE_PREFIX = exports.ENTITY_BASE_PREFIX = 'entities';
const ENTITY_HISTORY = exports.ENTITY_HISTORY = 'history';
const ENTITY_LATEST = exports.ENTITY_LATEST = 'latest';
const ENTITY_SCHEMA_VERSION_V1 = exports.ENTITY_SCHEMA_VERSION_V1 = 'v1';
function entitiesIndexPattern({
  schemaVersion,
  dataset,
  definitionId
}) {
  return `.${ENTITY_BASE_PREFIX}.${schemaVersion}.${dataset}.${definitionId}`;
}
function entitiesAliasPattern({
  type,
  dataset
}) {
  return `${ENTITY_BASE_PREFIX}-${type}-${dataset}`;
}