"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceRow = void 0;
var _react = _interopRequireDefault(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
var _source_icon = require("../source_icon");
require("./source_row.scss");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// i18n is not needed here because this is only used to check against the server error, which
// is not translated by the Kibana team at this time.
const CREDENTIALS_REFRESH_NEEDED_PREFIX = 'OAuth access token could not be refreshed';
const SourceRow = ({
  source: {
    id,
    serviceType,
    searchable,
    supportedByLicense,
    status,
    statusMessage,
    name,
    documentCount,
    isFederatedSource,
    errorReason,
    allowsReauth,
    activities,
    mainIcon
  },
  onSearchableToggle,
  isOrganization,
  showDetails
}) => {
  var _activities$, _activities$$status;
  const isIndexing = status === _constants.SOURCE_STATUSES.INDEXING;
  const hasError = status === _constants.SOURCE_STATUSES.ERROR || status === _constants.SOURCE_STATUSES.DISCONNECTED;
  const showReauthenticate = hasError && allowsReauth && (errorReason === null || errorReason === void 0 ? void 0 : errorReason.startsWith(CREDENTIALS_REFRESH_NEEDED_PREFIX)) && ((_activities$ = activities[0]) === null || _activities$ === void 0 ? void 0 : (_activities$$status = _activities$.status) === null || _activities$$status === void 0 ? void 0 : _activities$$status.toLowerCase()) === _constants.SOURCE_STATUSES.ERROR;
  const rowClass = (0, _classnames.default)({
    'source-row--error': hasError
  });
  const reauthenticateLink = /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    to: (0, _routes.getSourcesPath)(`${_routes.ADD_SOURCE_PATH}/${serviceType}/reauthenticate?sourceId=${id}`, isOrganization)
  }, _constants2.SOURCE_ROW_REAUTHENTICATE_STATUS_LINK_LABEL);
  const remoteTooltip = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", null, _constants2.SOURCE_ROW_REMOTE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: _constants2.SOURCE_ROW_REMOTE_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "questionInCircle"
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, {
    "data-test-subj": "GroupsRow",
    className: rowClass
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_source_icon.SourceIcon, {
    serviceType: isIndexing ? 'loadingSmall' : serviceType,
    name: name,
    iconAsBase64: mainIcon
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, name))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    alignItems: "center",
    responsive: false,
    gutterSize: "xs"
  }, status === 'need-more-config' && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "m",
    type: "dot",
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: status === 'need-more-config' ? 'default' : 'subdued',
    size: "xs"
  }, statusMessage)))), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    "data-test-subj": "SourceDocumentCount"
  }, isFederatedSource ? remoteTooltip : parseInt(documentCount, 10).toLocaleString('en-US')), onSearchableToggle && /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: searchable,
    onChange: e => onSearchableToggle(id, e.target.checked),
    disabled: !supportedByLicense,
    compressed: true,
    label: _constants2.SOURCE_ROW_SEARCHABLE_TOGGLE_LABEL,
    showLabel: false,
    "data-test-subj": "SourceSearchableToggle"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    align: "right"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center",
    gutterSize: "s"
  }, showReauthenticate && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, reauthenticateLink), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showDetails && /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    className: "eui-textNoWrap",
    "data-test-subj": "SourceDetailsLink",
    to: (0, _routes.getContentSourcePath)(_routes.SOURCE_DETAILS_PATH, id, !!isOrganization)
  }, _constants2.SOURCE_ROW_DETAILS_LABEL)))));
};
exports.SourceRow = SourceRow;