"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerConfiguration = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../../../common/types/api");
var _doc_links = require("../../../../../shared/doc_links");
var _index_view_logic = require("../../index_view_logic");
var _crawler_configuration_logic = require("./crawler_configuration_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerConfiguration = () => {
  const {
    htmlExtraction
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    status
  } = (0, _kea.useValues)(_crawler_configuration_logic.CrawlerConfigurationLogic);
  const {
    updateHtmlExtraction
  } = (0, _kea.useActions)(_crawler_configuration_logic.CrawlerConfigurationLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.crawlerConfiguration.extractHTML.title', {
    defaultMessage: 'Store full HTML'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.crawlerConfiguration.extractHTML.addExtraFieldDescription', {
    defaultMessage: 'Add an extra field in all documents with the value of the full HTML of the page being crawled.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.crawlerConfiguration.extractHTML.increasedSizeWarning', {
    defaultMessage: 'This may dramatically increase the index size if the site being crawled is large.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-telemetry-id": "entSearchContent-crawler-configuration-extractHtml",
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.crawlerConfiguration.extractHTML.extractionSwitchLabel', {
      defaultMessage: 'Store full HTML'
    }),
    disabled: status === _api.Status.LOADING,
    checked: htmlExtraction !== null && htmlExtraction !== void 0 ? htmlExtraction : false,
    onChange: event => updateHtmlExtraction(event.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: `${_doc_links.docLinks.crawlerManaging}#crawler-managing-html-storage`,
    "data-telemetry-id": "entSearchContent-crawler-configuration-learnMoreExtraction"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.crawler.crawlerConfiguration.extractHTML.learnMoreLink', {
    defaultMessage: 'Learn more about storing full HTML.'
  })))))));
};
exports.CrawlerConfiguration = CrawlerConfiguration;