"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyoutMultipleCrawlDelete = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _crawl_custom_settings_flyout_multi_crawl_logic = require("./crawl_custom_settings_flyout_multi_crawl_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlCustomSettingsFlyoutMultipleCrawlDelete = () => {
  const {
    crawlerConfigActiveTab,
    crawlerConfigurations
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic);
  const {
    onDeleteCustomCrawler
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "trash",
    color: "danger",
    disabled: crawlerConfigurations.length < 2,
    onClick: () => onDeleteCustomCrawler(crawlerConfigActiveTab)
  }, `Delete Crawl ${crawlerConfigActiveTab + 1}`));
};
exports.CrawlCustomSettingsFlyoutMultipleCrawlDelete = CrawlCustomSettingsFlyoutMultipleCrawlDelete;