"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewConnectorTemplate = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _beta_connector_callout = require("../../../../shared/beta/beta_connector_callout");
var _constants2 = require("../../../../shared/constants");
var _doc_links = require("../../../../shared/doc_links");
var _new_connector_logic = require("./new_connector_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewConnectorTemplate = ({
  buttonLoading,
  disabled,
  error,
  onNameChange,
  onSubmit,
  type,
  isBeta
}) => {
  const {
    connectorName,
    rawName
  } = (0, _kea.useValues)(_new_connector_logic.NewConnectorLogic);
  const {
    setRawName
  } = (0, _kea.useActions)(_new_connector_logic.NewConnectorLogic);
  const handleNameChange = e => {
    setRawName(e.target.value);
    if (onNameChange) {
      onNameChange(connectorName);
    }
  };
  const formInvalid = !!error;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    id: "enterprise-search-create-connector",
    onSubmit: event => {
      event.preventDefault();
      onSubmit(connectorName);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isBeta ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.formTitle",
    defaultMessage: "Create a connector"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isDisabled: disabled || buttonLoading,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.nameInputLabel', {
      defaultMessage: 'Connector name'
    }),
    isInvalid: formInvalid,
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "enterpriseSearchNewConnectorTemplateFieldText",
    "data-telemetry-id": `entSearchContent-${type}-newConnector-editName`,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.nameInputPlaceholder', {
      defaultMessage: 'Set a name for your connector'
    }),
    fullWidth: true,
    disabled: disabled,
    isInvalid: false,
    value: rawName,
    onChange: handleNameChange,
    autoFocus: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.nameInputHelpText.lineTwo', {
    defaultMessage: 'Names should be lowercase and cannot contain spaces or special characters.'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, type === _constants.INGESTION_METHOD_IDS.CONNECTOR && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchNewConnectorTemplateLearnMoreAboutConnectorsLink",
    target: "_blank",
    href: _doc_links.docLinks.connectors
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.learnMoreConnectors.linkText', {
    defaultMessage: 'Learn more about connectors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchNewConnectorTemplateButton",
    "data-telemetry-id": `entSearchContent-${type}-newConnector-goBack`,
    isDisabled: buttonLoading,
    onClick: () => history.back()
  }, _constants2.BACK_BUTTON_LABEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": `entSearchContent-${type}-newConnector-createConnector`,
    "data-telemetry-id": `entSearchContent-${type}-newConnector-createConnector`,
    fill: true,
    isDisabled: !rawName || buttonLoading || formInvalid || disabled,
    isLoading: buttonLoading,
    type: "submit"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.newConnector.newConnectorTemplate.createIndex.buttonText', {
    defaultMessage: 'Create connector'
  }))))));
};
exports.NewConnectorTemplate = NewConnectorTemplate;