"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEngineSchema = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _data_panel = require("../../data_panel");
var _engine = require("../../engine");
var _layout = require("../../layout");
var _components = require("../components");
var _constants = require("../constants");
var _schema_meta_engine_logic = require("../schema_meta_engine_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEngineSchema = () => {
  const {
    loadSchema
  } = (0, _kea.useActions)(_schema_meta_engine_logic.MetaEngineSchemaLogic);
  const {
    dataLoading,
    hasConflicts,
    conflictingFieldsCount
  } = (0, _kea.useValues)(_schema_meta_engine_logic.MetaEngineSchemaLogic);
  (0, _react.useEffect)(() => {
    loadSchema();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants.SCHEMA_TITLE]),
    pageHeader: {
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.title', {
        defaultMessage: 'Meta engine schema'
      }),
      description: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.description', {
        defaultMessage: 'Active and inactive fields, by engine.'
      })
    },
    isLoading: dataLoading
  }, hasConflicts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "warning",
    color: "warning",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.conflictsCalloutTitle', {
      defaultMessage: '{conflictingFieldsCount, plural, one {# field is} other {# fields are}} not searchable',
      values: {
        conflictingFieldsCount
      }
    })
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.conflictsCalloutDescription', {
    defaultMessage: 'The field(s) have an inconsistent field-type across the source engines that make up this meta engine. Apply a consistent field-type from the source engines to make these fields searchable.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.activeFieldsTitle', {
      defaultMessage: 'Active fields'
    })),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.activeFieldsDescription', {
      defaultMessage: 'Fields which belong to one or more engine.'
    })
  }, /*#__PURE__*/_react.default.createElement(_components.MetaEnginesSchemaTable, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), hasConflicts && /*#__PURE__*/_react.default.createElement(_data_panel.DataPanel, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.inactiveFieldsTitle', {
      defaultMessage: 'Inactive fields'
    })),
    subtitle: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.schema.metaEngine.inactiveFieldsDescription', {
      defaultMessage: 'These fields have type conflicts. To activate these fields, change types in the source engines to match.'
    })
  }, /*#__PURE__*/_react.default.createElement(_components.MetaEnginesConflictsTable, null)));
};
exports.MetaEngineSchema = MetaEngineSchema;