"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoleMappings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../common/constants");
var _doc_links = require("../../../shared/doc_links");
var _role_mapping = require("../../../shared/role_mapping");
var _constants2 = require("../../../shared/role_mapping/constants");
var _layout = require("../layout");
var _constants3 = require("./constants");
var _role_mapping2 = require("./role_mapping");
var _role_mappings_logic = require("./role_mappings_logic");
var _user = require("./user");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RoleMappings = () => {
  const {
    enableRoleBasedAccess,
    initializeRoleMappings,
    initializeRoleMapping,
    initializeSingleUserRoleMapping,
    handleDeleteMapping,
    resetState
  } = (0, _kea.useActions)(_role_mappings_logic.RoleMappingsLogic);
  const {
    roleMappings,
    singleUserRoleMappings,
    dataLoading,
    roleMappingFlyoutOpen,
    singleUserRoleMappingFlyoutOpen
  } = (0, _kea.useValues)(_role_mappings_logic.RoleMappingsLogic);
  (0, _react.useEffect)(() => {
    initializeRoleMappings();
    return resetState;
  }, []);
  const hasUsers = singleUserRoleMappings.length > 0;
  const rolesEmptyState = /*#__PURE__*/_react.default.createElement(_role_mapping.RolesEmptyPrompt, {
    productName: _constants.APP_SEARCH_PLUGIN.NAME,
    docsLink: _doc_links.docLinks.appSearchSecurity,
    onEnable: enableRoleBasedAccess
  });
  const roleMappingsSection = /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement(_role_mapping.RoleMappingsHeading, {
    productName: _constants.APP_SEARCH_PLUGIN.NAME,
    docsLink: _doc_links.docLinks.appSearchSecurity,
    onClick: () => initializeRoleMapping()
  }), /*#__PURE__*/_react.default.createElement(_role_mapping.RoleMappingsTable, {
    roleMappings: roleMappings,
    accessItemKey: "engines",
    accessHeader: _constants3.ROLE_MAPPINGS_ENGINE_ACCESS_HEADING,
    initializeRoleMapping: initializeRoleMapping,
    handleDeleteMapping: handleDeleteMapping
  }));
  const usersTable = /*#__PURE__*/_react.default.createElement(_role_mapping.UsersTable, {
    accessItemKey: "engines",
    singleUserRoleMappings: singleUserRoleMappings,
    initializeSingleUserRoleMapping: initializeSingleUserRoleMapping,
    handleDeleteMapping: handleDeleteMapping
  });
  const usersSection = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_role_mapping.UsersHeading, {
    onClick: () => initializeSingleUserRoleMapping()
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), hasUsers ? usersTable : /*#__PURE__*/_react.default.createElement(_role_mapping.UsersEmptyPrompt, null));
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: [_constants2.ROLE_MAPPINGS_TITLE],
    pageHeader: {
      pageTitle: _constants2.ROLE_MAPPINGS_TITLE
    },
    isLoading: dataLoading,
    isEmptyState: roleMappings.length < 1,
    emptyState: rolesEmptyState
  }, roleMappingFlyoutOpen && /*#__PURE__*/_react.default.createElement(_role_mapping2.RoleMapping, null), singleUserRoleMappingFlyoutOpen && /*#__PURE__*/_react.default.createElement(_user.User, null), roleMappingsSection, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), usersSection);
};
exports.RoleMappings = RoleMappings;